/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.transform.FaceRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FaceRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceRecord> {
    private final Face face;
    private final FaceDetail faceDetail;

    private FaceRecord(BuilderImpl builder) {
        this.face = builder.face;
        this.faceDetail = builder.faceDetail;
    }

    public Face face() {
        return this.face;
    }

    public FaceDetail faceDetail() {
        return this.faceDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceRecord)) {
            return false;
        }
        FaceRecord other = (FaceRecord)obj;
        return Objects.equals(this.face(), other.face()) && Objects.equals(this.faceDetail(), other.faceDetail());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.face() != null) {
            sb.append("Face: ").append(this.face()).append(",");
        }
        if (this.faceDetail() != null) {
            sb.append("FaceDetail: ").append(this.faceDetail()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Face": {
                return Optional.of(clazz.cast(this.face()));
            }
            case "FaceDetail": {
                return Optional.of(clazz.cast(this.faceDetail()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Face face;
        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceRecord model) {
            this.face(model.face);
            this.faceDetail(model.faceDetail);
        }

        public final Face.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public final FaceDetail.Builder getFaceDetail() {
            return this.faceDetail != null ? this.faceDetail.toBuilder() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        public FaceRecord build() {
            return new FaceRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceRecord> {
        public Builder face(Face var1);

        default public Builder face(Consumer<Face.Builder> face) {
            return this.face((Face)((Face.Builder)Face.builder().apply(face)).build());
        }

        public Builder faceDetail(FaceDetail var1);

        default public Builder faceDetail(Consumer<FaceDetail.Builder> faceDetail) {
            return this.faceDetail((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().apply(faceDetail)).build());
        }
    }
}

