/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Image;

@SdkInternalApi
public class ImageMarshaller {
    private static final MarshallingInfo<ByteBuffer> BYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bytes").build();
    private static final MarshallingInfo<StructuredPojo> S3OBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Object").build();
    private static final ImageMarshaller INSTANCE = new ImageMarshaller();

    public static ImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Image image, ProtocolMarshaller protocolMarshaller) {
        if (image == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)image.bytes(), BYTES_BINDING);
            protocolMarshaller.marshall((Object)image.s3Object(), S3OBJECT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

