/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.Attribute;
import software.amazon.awssdk.services.rekognition.model.AttributesCopier;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IndexFacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, IndexFacesRequest> {
    private final String collectionId;
    private final Image image;
    private final String externalImageId;
    private final List<String> detectionAttributes;

    private IndexFacesRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Image image() {
        return this.image;
    }

    public String externalImageId() {
        return this.externalImageId;
    }

    public List<String> detectionAttributes() {
        return this.detectionAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.collectionId() == null ? 0 : this.collectionId().hashCode());
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.externalImageId() == null ? 0 : this.externalImageId().hashCode());
        hashCode = 31 * hashCode + (this.detectionAttributes() == null ? 0 : this.detectionAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest)((Object)obj);
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.externalImageId() == null ^ this.externalImageId() == null) {
            return false;
        }
        if (other.externalImageId() != null && !other.externalImageId().equals(this.externalImageId())) {
            return false;
        }
        if (other.detectionAttributes() == null ^ this.detectionAttributes() == null) {
            return false;
        }
        return other.detectionAttributes() == null || other.detectionAttributes().equals(this.detectionAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.collectionId() != null) {
            sb.append("CollectionId: ").append(this.collectionId()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.externalImageId() != null) {
            sb.append("ExternalImageId: ").append(this.externalImageId()).append(",");
        }
        if (this.detectionAttributes() != null) {
            sb.append("DetectionAttributes: ").append(this.detectionAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private String externalImageId;
        private List<String> detectionAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            this.setCollectionId(model.collectionId);
            this.setImage(model.image);
            this.setExternalImageId(model.externalImageId);
            this.setDetectionAttributes(model.detectionAttributes);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image getImage() {
            return this.image;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image image) {
            this.image = image;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Collection<String> getDetectionAttributes() {
            return this.detectionAttributes;
        }

        @Override
        public final Builder detectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(String ... detectionAttributes) {
            this.detectionAttributes(Arrays.asList(detectionAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(Attribute ... detectionAttributes) {
            this.detectionAttributes(Arrays.asList(detectionAttributes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IndexFacesRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        public Builder externalImageId(String var1);

        public Builder detectionAttributes(Collection<String> var1);

        public Builder detectionAttributes(String ... var1);

        public Builder detectionAttributes(Attribute ... var1);
    }
}

