/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;

public class BoundingBoxUnmarshaller
implements Unmarshaller<BoundingBox, JsonUnmarshallerContext> {
    private static final BoundingBoxUnmarshaller INSTANCE = new BoundingBoxUnmarshaller();

    public BoundingBox unmarshall(JsonUnmarshallerContext context) throws Exception {
        BoundingBox.Builder boundingBoxBuilder = BoundingBox.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Width", targetDepth)) {
                    context.nextToken();
                    boundingBoxBuilder.width((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Height", targetDepth)) {
                    context.nextToken();
                    boundingBoxBuilder.height((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Left", targetDepth)) {
                    context.nextToken();
                    boundingBoxBuilder.left((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Top", targetDepth)) {
                    context.nextToken();
                    boundingBoxBuilder.top((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BoundingBox)boundingBoxBuilder.build();
    }

    public static BoundingBoxUnmarshaller getInstance() {
        return INSTANCE;
    }
}

