/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ImageQualityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageQuality
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageQuality> {
    private final Float brightness;
    private final Float sharpness;

    private ImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
    }

    public Float brightness() {
        return this.brightness;
    }

    public Float sharpness() {
        return this.sharpness;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.brightness() == null ? 0 : this.brightness().hashCode());
        hashCode = 31 * hashCode + (this.sharpness() == null ? 0 : this.sharpness().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageQuality)) {
            return false;
        }
        ImageQuality other = (ImageQuality)obj;
        if (other.brightness() == null ^ this.brightness() == null) {
            return false;
        }
        if (other.brightness() != null && !other.brightness().equals(this.brightness())) {
            return false;
        }
        if (other.sharpness() == null ^ this.sharpness() == null) {
            return false;
        }
        return other.sharpness() == null || other.sharpness().equals(this.sharpness());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.brightness() != null) {
            sb.append("Brightness: ").append(this.brightness()).append(",");
        }
        if (this.sharpness() != null) {
            sb.append("Sharpness: ").append(this.sharpness()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageQualityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Float brightness;
        private Float sharpness;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageQuality model) {
            this.setBrightness(model.brightness);
            this.setSharpness(model.sharpness);
        }

        public final Float getBrightness() {
            return this.brightness;
        }

        @Override
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        public final Float getSharpness() {
            return this.sharpness;
        }

        @Override
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        public ImageQuality build() {
            return new ImageQuality(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageQuality> {
        public Builder brightness(Float var1);

        public Builder sharpness(Float var1);
    }
}

