/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.services.rekognition.model.ModerationLabelsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectModerationLabelsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DetectModerationLabelsResponse> {
    private final List<ModerationLabel> moderationLabels;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        this.moderationLabels = builder.moderationLabels;
    }

    public List<ModerationLabel> moderationLabels() {
        return this.moderationLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.moderationLabels() == null ? 0 : this.moderationLabels().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse)((Object)obj);
        if (other.moderationLabels() == null ^ this.moderationLabels() == null) {
            return false;
        }
        return other.moderationLabels() == null || other.moderationLabels().equals(this.moderationLabels());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.moderationLabels() != null) {
            sb.append("ModerationLabels: ").append(this.moderationLabels()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ModerationLabel> moderationLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            this.setModerationLabels(model.moderationLabels);
        }

        public final Collection<ModerationLabel> getModerationLabels() {
            return this.moderationLabels;
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel ... moderationLabels) {
            this.moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        public final void setModerationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
        }

        @SafeVarargs
        public final void setModerationLabels(ModerationLabel ... moderationLabels) {
            this.moderationLabels(Arrays.asList(moderationLabels));
        }

        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        public Builder moderationLabels(Collection<ModerationLabel> var1);

        public Builder moderationLabels(ModerationLabel ... var1);
    }
}

