/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.Label;
import software.amazon.awssdk.services.rekognition.model.LabelsCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectLabelsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DetectLabelsResponse> {
    private final List<Label> labels;
    private final String orientationCorrection;

    private DetectLabelsResponse(BuilderImpl builder) {
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<Label> labels() {
        return this.labels;
    }

    public String orientationCorrection() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.labels() == null ? 0 : this.labels().hashCode());
        hashCode = 31 * hashCode + (this.orientationCorrection() == null ? 0 : this.orientationCorrection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse)((Object)obj);
        if (other.labels() == null ^ this.labels() == null) {
            return false;
        }
        if (other.labels() != null && !other.labels().equals(this.labels())) {
            return false;
        }
        if (other.orientationCorrection() == null ^ this.orientationCorrection() == null) {
            return false;
        }
        return other.orientationCorrection() == null || other.orientationCorrection().equals(this.orientationCorrection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        if (this.orientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.orientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Label> labels;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            this.setLabels(model.labels);
            this.setOrientationCorrection(model.orientationCorrection);
        }

        public final Collection<Label> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
        }

        @SafeVarargs
        public final void setLabels(Label ... labels) {
            this.labels(Arrays.asList(labels));
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final void setOrientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
        }

        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetectLabelsResponse> {
        public Builder labels(Collection<Label> var1);

        public Builder labels(Label ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

