/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamProcessorSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> FACESEARCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceSearch").isBinary(false).build();
    private static final StreamProcessorSettingsMarshaller INSTANCE = new StreamProcessorSettingsMarshaller();

    private StreamProcessorSettingsMarshaller() {
    }

    public static StreamProcessorSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamProcessorSettings streamProcessorSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamProcessorSettings, (String)"streamProcessorSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamProcessorSettings.faceSearch(), FACESEARCH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

