/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartContentModerationRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> VIDEO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Video").isBinary(false).build();
    private static final MarshallingInfo<Float> MINCONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinConfidence").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationChannel").isBinary(false).build();
    private static final MarshallingInfo<String> JOBTAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobTag").isBinary(false).build();
    private static final StartContentModerationRequestModelMarshaller INSTANCE = new StartContentModerationRequestModelMarshaller();

    private StartContentModerationRequestModelMarshaller() {
    }

    public static StartContentModerationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartContentModerationRequest startContentModerationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startContentModerationRequest), (String)"startContentModerationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startContentModerationRequest.video(), VIDEO_BINDING);
            protocolMarshaller.marshall((Object)startContentModerationRequest.minConfidence(), MINCONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)startContentModerationRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)startContentModerationRequest.notificationChannel(), NOTIFICATIONCHANNEL_BINDING);
            protocolMarshaller.marshall((Object)startContentModerationRequest.jobTag(), JOBTAG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

