/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.PersonMatch;
import software.amazon.awssdk.services.rekognition.transform.FaceMatchUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.PersonDetailUnmarshaller;

public class PersonMatchUnmarshaller
implements Unmarshaller<PersonMatch, JsonUnmarshallerContext> {
    private static final PersonMatchUnmarshaller INSTANCE = new PersonMatchUnmarshaller();

    public PersonMatch unmarshall(JsonUnmarshallerContext context) throws Exception {
        PersonMatch.Builder personMatchBuilder = PersonMatch.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    context.nextToken();
                    personMatchBuilder.timestamp((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Person", targetDepth)) {
                    context.nextToken();
                    personMatchBuilder.person(PersonDetailUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("FaceMatches", targetDepth)) {
                    context.nextToken();
                    personMatchBuilder.faceMatches(new ListUnmarshaller((Unmarshaller)FaceMatchUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PersonMatch)personMatchBuilder.build();
    }

    public static PersonMatchUnmarshaller getInstance() {
        return INSTANCE;
    }
}

