/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.PersonMatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PersonMatchMarshaller {
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PERSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Person").isBinary(false).build();
    private static final MarshallingInfo<List> FACEMATCHES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceMatches").isBinary(false).build();
    private static final PersonMatchMarshaller INSTANCE = new PersonMatchMarshaller();

    private PersonMatchMarshaller() {
    }

    public static PersonMatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PersonMatch personMatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)personMatch, (String)"personMatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)personMatch.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)personMatch.person(), PERSON_BINDING);
            protocolMarshaller.marshall(personMatch.faceMatches(), FACEMATCHES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

