/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.PersonDetection;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PersonDetectionMarshaller {
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PERSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Person").isBinary(false).build();
    private static final PersonDetectionMarshaller INSTANCE = new PersonDetectionMarshaller();

    private PersonDetectionMarshaller() {
    }

    public static PersonDetectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PersonDetection personDetection, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)personDetection, (String)"personDetection");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)personDetection.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)personDetection.person(), PERSON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

