/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.KinesisVideoStream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisVideoStreamMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final KinesisVideoStreamMarshaller INSTANCE = new KinesisVideoStreamMarshaller();

    private KinesisVideoStreamMarshaller() {
    }

    public static KinesisVideoStreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisVideoStream kinesisVideoStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisVideoStream, (String)"kinesisVideoStream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisVideoStream.arn(), ARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

