/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeCollectionRequestModelMarshaller {
    private static final MarshallingInfo<String> COLLECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionId").isBinary(false).build();
    private static final DescribeCollectionRequestModelMarshaller INSTANCE = new DescribeCollectionRequestModelMarshaller();

    private DescribeCollectionRequestModelMarshaller() {
    }

    public static DescribeCollectionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeCollectionRequest describeCollectionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeCollectionRequest), (String)"describeCollectionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeCollectionRequest.collectionId(), COLLECTIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

