/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateStreamProcessorRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> INPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Input").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Output").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Settings").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final CreateStreamProcessorRequestModelMarshaller INSTANCE = new CreateStreamProcessorRequestModelMarshaller();

    private CreateStreamProcessorRequestModelMarshaller() {
    }

    public static CreateStreamProcessorRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStreamProcessorRequest createStreamProcessorRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createStreamProcessorRequest), (String)"createStreamProcessorRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createStreamProcessorRequest.input(), INPUT_BINDING);
            protocolMarshaller.marshall((Object)createStreamProcessorRequest.output(), OUTPUT_BINDING);
            protocolMarshaller.marshall((Object)createStreamProcessorRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamProcessorRequest.settings(), SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)createStreamProcessorRequest.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

