/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CelebrityDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CelebrityDetailMarshaller {
    private static final MarshallingInfo<List> URLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Urls").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").isBinary(false).build();
    private static final CelebrityDetailMarshaller INSTANCE = new CelebrityDetailMarshaller();

    private CelebrityDetailMarshaller() {
    }

    public static CelebrityDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CelebrityDetail celebrityDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)celebrityDetail, (String)"celebrityDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(celebrityDetail.urls(), URLS_BINDING);
            protocolMarshaller.marshall((Object)celebrityDetail.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)celebrityDetail.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)celebrityDetail.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)celebrityDetail.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)celebrityDetail.face(), FACE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

