/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Geometry;
import software.amazon.awssdk.services.rekognition.model.TextTypes;
import software.amazon.awssdk.services.rekognition.transform.TextDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextDetection
implements StructuredPojo,
ToCopyableBuilder<Builder, TextDetection> {
    private final String detectedText;
    private final String type;
    private final Integer id;
    private final Integer parentId;
    private final Float confidence;
    private final Geometry geometry;

    private TextDetection(BuilderImpl builder) {
        this.detectedText = builder.detectedText;
        this.type = builder.type;
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.confidence = builder.confidence;
        this.geometry = builder.geometry;
    }

    public String detectedText() {
        return this.detectedText;
    }

    public TextTypes type() {
        return TextTypes.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Integer id() {
        return this.id;
    }

    public Integer parentId() {
        return this.parentId;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Geometry geometry() {
        return this.geometry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDetection)) {
            return false;
        }
        TextDetection other = (TextDetection)obj;
        return Objects.equals(this.detectedText(), other.detectedText()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.geometry(), other.geometry());
    }

    public String toString() {
        return ToString.builder((String)"TextDetection").add("DetectedText", (Object)this.detectedText()).add("Type", (Object)this.typeAsString()).add("Id", (Object)this.id()).add("ParentId", (Object)this.parentId()).add("Confidence", (Object)this.confidence()).add("Geometry", (Object)this.geometry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectedText": {
                return Optional.ofNullable(clazz.cast(this.detectedText()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TextDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectedText;
        private String type;
        private Integer id;
        private Integer parentId;
        private Float confidence;
        private Geometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDetection model) {
            this.detectedText(model.detectedText);
            this.type(model.type);
            this.id(model.id);
            this.parentId(model.parentId);
            this.confidence(model.confidence);
            this.geometry(model.geometry);
        }

        public final String getDetectedText() {
            return this.detectedText;
        }

        @Override
        public final Builder detectedText(String detectedText) {
            this.detectedText = detectedText;
            return this;
        }

        public final void setDetectedText(String detectedText) {
            this.detectedText = detectedText;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TextTypes type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(Integer parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(Integer parentId) {
            this.parentId = parentId;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        public TextDetection build() {
            return new TextDetection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TextDetection> {
        public Builder detectedText(String var1);

        public Builder type(String var1);

        public Builder type(TextTypes var1);

        public Builder id(Integer var1);

        public Builder parentId(Integer var1);

        public Builder confidence(Float var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }
    }
}

