/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rekognition.model.NotificationChannel;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.Video;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContentModerationRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartContentModerationRequest> {
    private final Video video;
    private final Float minConfidence;
    private final String clientRequestToken;
    private final NotificationChannel notificationChannel;
    private final String jobTag;

    private StartContentModerationRequest(BuilderImpl builder) {
        super(builder);
        this.video = builder.video;
        this.minConfidence = builder.minConfidence;
        this.clientRequestToken = builder.clientRequestToken;
        this.notificationChannel = builder.notificationChannel;
        this.jobTag = builder.jobTag;
    }

    public Video video() {
        return this.video;
    }

    public Float minConfidence() {
        return this.minConfidence;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public NotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public String jobTag() {
        return this.jobTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContentModerationRequest)) {
            return false;
        }
        StartContentModerationRequest other = (StartContentModerationRequest)((Object)obj);
        return Objects.equals(this.video(), other.video()) && Objects.equals(this.minConfidence(), other.minConfidence()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.jobTag(), other.jobTag());
    }

    public String toString() {
        return ToString.builder((String)"StartContentModerationRequest").add("Video", (Object)this.video()).add("MinConfidence", (Object)this.minConfidence()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("NotificationChannel", (Object)this.notificationChannel()).add("JobTag", (Object)this.jobTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Video video;
        private Float minConfidence;
        private String clientRequestToken;
        private NotificationChannel notificationChannel;
        private String jobTag;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContentModerationRequest model) {
            super(model);
            this.video(model.video);
            this.minConfidence(model.minConfidence);
            this.clientRequestToken(model.clientRequestToken);
            this.notificationChannel(model.notificationChannel);
            this.jobTag(model.jobTag);
        }

        public final Video.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContentModerationRequest build() {
            return new StartContentModerationRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, StartContentModerationRequest> {
        public Builder video(Video var1);

        default public Builder video(Consumer<Video.Builder> video) {
            return this.video((Video)((Video.Builder)Video.builder().applyMutation(video)).build());
        }

        public Builder minConfidence(Float var1);

        public Builder clientRequestToken(String var1);

        public Builder notificationChannel(NotificationChannel var1);

        default public Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder jobTag(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

