/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, SearchFacesResponse> {
    private final String searchedFaceId;
    private final List<FaceMatch> faceMatches;
    private final String faceModelVersion;

    private SearchFacesResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceId = builder.searchedFaceId;
        this.faceMatches = builder.faceMatches;
        this.faceModelVersion = builder.faceModelVersion;
    }

    public String searchedFaceId() {
        return this.searchedFaceId;
    }

    public List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public String faceModelVersion() {
        return this.faceModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesResponse)) {
            return false;
        }
        SearchFacesResponse other = (SearchFacesResponse)((Object)obj);
        return Objects.equals(this.searchedFaceId(), other.searchedFaceId()) && Objects.equals(this.faceMatches(), other.faceMatches()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion());
    }

    public String toString() {
        return ToString.builder((String)"SearchFacesResponse").add("SearchedFaceId", (Object)this.searchedFaceId()).add("FaceMatches", this.faceMatches()).add("FaceModelVersion", (Object)this.faceModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchedFaceId": {
                return Optional.ofNullable(clazz.cast(this.searchedFaceId()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String searchedFaceId;
        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();
        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesResponse model) {
            super(model);
            this.searchedFaceId(model.searchedFaceId);
            this.faceMatches(model.faceMatches);
            this.faceModelVersion(model.faceModelVersion);
        }

        public final String getSearchedFaceId() {
            return this.searchedFaceId;
        }

        @Override
        public final Builder searchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
            return this;
        }

        public final void setSearchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (FaceMatch)((FaceMatch.Builder)FaceMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public SearchFacesResponse build() {
            return new SearchFacesResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, SearchFacesResponse> {
        public Builder searchedFaceId(String var1);

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);

        public Builder faceMatches(Consumer<FaceMatch.Builder> ... var1);

        public Builder faceModelVersion(String var1);
    }
}

