/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CollectionIdListCopier;
import software.amazon.awssdk.services.rekognition.model.FaceModelVersionListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollectionsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListCollectionsResponse> {
    private final List<String> collectionIds;
    private final String nextToken;
    private final List<String> faceModelVersions;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
        this.faceModelVersions = builder.faceModelVersions;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> faceModelVersions() {
        return this.faceModelVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse)((Object)obj);
        return Objects.equals(this.collectionIds(), other.collectionIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.faceModelVersions(), other.faceModelVersions());
    }

    public String toString() {
        return ToString.builder((String)"ListCollectionsResponse").add("CollectionIds", this.collectionIds()).add("NextToken", (Object)this.nextToken()).add("FaceModelVersions", this.faceModelVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionIds": {
                return Optional.ofNullable(clazz.cast(this.collectionIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FaceModelVersions": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> collectionIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<String> faceModelVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            this.collectionIds(model.collectionIds);
            this.nextToken(model.nextToken);
            this.faceModelVersions(model.faceModelVersions);
        }

        public final Collection<String> getCollectionIds() {
            return this.collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String ... collectionIds) {
            this.collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getFaceModelVersions() {
            return this.faceModelVersions;
        }

        @Override
        public final Builder faceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceModelVersions(String ... faceModelVersions) {
            this.faceModelVersions(Arrays.asList(faceModelVersions));
            return this;
        }

        public final void setFaceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, ListCollectionsResponse> {
        public Builder collectionIds(Collection<String> var1);

        public Builder collectionIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder faceModelVersions(Collection<String> var1);

        public Builder faceModelVersions(String ... var1);
    }
}

