/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.PersonMatch;
import software.amazon.awssdk.services.rekognition.model.PersonMatchesCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFaceSearchResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetFaceSearchResponse> {
    private final String jobStatus;
    private final String statusMessage;
    private final String nextToken;
    private final VideoMetadata videoMetadata;
    private final List<PersonMatch> persons;

    private GetFaceSearchResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.nextToken = builder.nextToken;
        this.videoMetadata = builder.videoMetadata;
        this.persons = builder.persons;
    }

    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public List<PersonMatch> persons() {
        return this.persons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.persons());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceSearchResponse)) {
            return false;
        }
        GetFaceSearchResponse other = (GetFaceSearchResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.persons(), other.persons());
    }

    public String toString() {
        return ToString.builder((String)"GetFaceSearchResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("NextToken", (Object)this.nextToken()).add("VideoMetadata", (Object)this.videoMetadata()).add("Persons", this.persons()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "Persons": {
                return Optional.ofNullable(clazz.cast(this.persons()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private String nextToken;
        private VideoMetadata videoMetadata;
        private List<PersonMatch> persons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceSearchResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.nextToken(model.nextToken);
            this.videoMetadata(model.videoMetadata);
            this.persons(model.persons);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final Collection<PersonMatch.Builder> getPersons() {
            return this.persons != null ? (Collection)this.persons.stream().map(PersonMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder persons(Collection<PersonMatch> persons) {
            this.persons = PersonMatchesCopier.copy(persons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(PersonMatch ... persons) {
            this.persons(Arrays.asList(persons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(Consumer<PersonMatch.Builder> ... persons) {
            this.persons(Stream.of(persons).map(c -> (PersonMatch)((PersonMatch.Builder)PersonMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPersons(Collection<PersonMatch.BuilderImpl> persons) {
            this.persons = PersonMatchesCopier.copyFromBuilder(persons);
        }

        @Override
        public GetFaceSearchResponse build() {
            return new GetFaceSearchResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, GetFaceSearchResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder nextToken(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder persons(Collection<PersonMatch> var1);

        public Builder persons(PersonMatch ... var1);

        public Builder persons(Consumer<PersonMatch.Builder> ... var1);
    }
}

