/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CelebrityDetail;
import software.amazon.awssdk.services.rekognition.transform.CelebrityRecognitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CelebrityRecognition
implements StructuredPojo,
ToCopyableBuilder<Builder, CelebrityRecognition> {
    private final Long timestamp;
    private final CelebrityDetail celebrity;

    private CelebrityRecognition(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.celebrity = builder.celebrity;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public CelebrityDetail celebrity() {
        return this.celebrity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.celebrity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CelebrityRecognition)) {
            return false;
        }
        CelebrityRecognition other = (CelebrityRecognition)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.celebrity(), other.celebrity());
    }

    public String toString() {
        return ToString.builder((String)"CelebrityRecognition").add("Timestamp", (Object)this.timestamp()).add("Celebrity", (Object)this.celebrity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Celebrity": {
                return Optional.ofNullable(clazz.cast(this.celebrity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CelebrityRecognitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private CelebrityDetail celebrity;

        private BuilderImpl() {
        }

        private BuilderImpl(CelebrityRecognition model) {
            this.timestamp(model.timestamp);
            this.celebrity(model.celebrity);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final CelebrityDetail.Builder getCelebrity() {
            return this.celebrity != null ? this.celebrity.toBuilder() : null;
        }

        @Override
        public final Builder celebrity(CelebrityDetail celebrity) {
            this.celebrity = celebrity;
            return this;
        }

        public final void setCelebrity(CelebrityDetail.BuilderImpl celebrity) {
            this.celebrity = celebrity != null ? celebrity.build() : null;
        }

        public CelebrityRecognition build() {
            return new CelebrityRecognition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CelebrityRecognition> {
        public Builder timestamp(Long var1);

        public Builder celebrity(CelebrityDetail var1);

        default public Builder celebrity(Consumer<CelebrityDetail.Builder> celebrity) {
            return this.celebrity((CelebrityDetail)((CelebrityDetail.Builder)CelebrityDetail.builder().applyMutation(celebrity)).build());
        }
    }
}

