/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.services.rekognition.transform.CelebrityDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CelebrityDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, CelebrityDetail> {
    private final List<String> urls;
    private final String name;
    private final String id;
    private final Float confidence;
    private final BoundingBox boundingBox;
    private final FaceDetail face;

    private CelebrityDetail(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.confidence = builder.confidence;
        this.boundingBox = builder.boundingBox;
        this.face = builder.face;
    }

    public List<String> urls() {
        return this.urls;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Float confidence() {
        return this.confidence;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public FaceDetail face() {
        return this.face;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.urls());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CelebrityDetail)) {
            return false;
        }
        CelebrityDetail other = (CelebrityDetail)obj;
        return Objects.equals(this.urls(), other.urls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.face(), other.face());
    }

    public String toString() {
        return ToString.builder((String)"CelebrityDetail").add("Urls", this.urls()).add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Confidence", (Object)this.confidence()).add("BoundingBox", (Object)this.boundingBox()).add("Face", (Object)this.face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CelebrityDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String id;
        private Float confidence;
        private BoundingBox boundingBox;
        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(CelebrityDetail model) {
            this.urls(model.urls);
            this.name(model.name);
            this.id(model.id);
            this.confidence(model.confidence);
            this.boundingBox(model.boundingBox);
            this.face(model.face);
        }

        public final Collection<String> getUrls() {
            return this.urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final FaceDetail.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public CelebrityDetail build() {
            return new CelebrityDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CelebrityDetail> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder confidence(Float var1);

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder face(FaceDetail var1);

        default public Builder face(Consumer<FaceDetail.Builder> face) {
            return this.face((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(face)).build());
        }
    }
}

