/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.AccessDeniedException;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectTextRequest;
import software.amazon.awssdk.services.rekognition.model.DetectTextResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.rekognition.model.ImageTooLargeException;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.InternalServerErrorException;
import software.amazon.awssdk.services.rekognition.model.InvalidImageFormatException;
import software.amazon.awssdk.services.rekognition.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.rekognition.model.InvalidParameterException;
import software.amazon.awssdk.services.rekognition.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.rekognition.model.LimitExceededException;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;
import software.amazon.awssdk.services.rekognition.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionException;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.rekognition.model.ResourceInUseException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.ThrottlingException;
import software.amazon.awssdk.services.rekognition.model.VideoTooLargeException;
import software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetContentModerationIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionIterable;
import software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingIterable;
import software.amazon.awssdk.services.rekognition.paginators.ListCollectionsIterable;
import software.amazon.awssdk.services.rekognition.paginators.ListFacesIterable;
import software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsIterable;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateStreamProcessorResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteStreamProcessorResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeStreamProcessorResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectTextRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectTextResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityRecognitionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetContentModerationResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceDetectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceSearchResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetLabelDetectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetPersonTrackingResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListStreamProcessorsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListStreamProcessorsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartCelebrityRecognitionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartContentModerationResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceDetectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceSearchResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartLabelDetectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartPersonTrackingResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartStreamProcessorResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopStreamProcessorResponseUnmarshaller;

@SdkInternalApi
final class DefaultRekognitionClient
implements RekognitionClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRekognitionClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "rekognition";
    }

    @Override
    public CompareFacesResponse compareFaces(CompareFacesRequest compareFacesRequest) throws InvalidParameterException, InvalidS3ObjectException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompareFacesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CompareFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)compareFacesRequest).withMarshaller((Marshaller)new CompareFacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCollectionResponse createCollection(CreateCollectionRequest createCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCollectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCollectionRequest).withMarshaller((Marshaller)new CreateCollectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStreamProcessorResponse createStreamProcessor(CreateStreamProcessorRequest createStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, LimitExceededException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStreamProcessorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStreamProcessorRequest).withMarshaller((Marshaller)new CreateStreamProcessorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCollectionResponse deleteCollection(DeleteCollectionRequest deleteCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCollectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCollectionRequest).withMarshaller((Marshaller)new DeleteCollectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteFacesResponse deleteFaces(DeleteFacesRequest deleteFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFacesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFacesRequest).withMarshaller((Marshaller)new DeleteFacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteStreamProcessorResponse deleteStreamProcessor(DeleteStreamProcessorRequest deleteStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStreamProcessorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStreamProcessorRequest).withMarshaller((Marshaller)new DeleteStreamProcessorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCollectionResponse describeCollection(DescribeCollectionRequest describeCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCollectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCollectionRequest).withMarshaller((Marshaller)new DescribeCollectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStreamProcessorResponse describeStreamProcessor(DescribeStreamProcessorRequest describeStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamProcessorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamProcessorRequest).withMarshaller((Marshaller)new DescribeStreamProcessorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectFacesResponse detectFaces(DetectFacesRequest detectFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectFacesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DetectFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectFacesRequest).withMarshaller((Marshaller)new DetectFacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectLabelsResponse detectLabels(DetectLabelsRequest detectLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectLabelsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DetectLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectLabelsRequest).withMarshaller((Marshaller)new DetectLabelsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectModerationLabelsResponse detectModerationLabels(DetectModerationLabelsRequest detectModerationLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectModerationLabelsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DetectModerationLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectModerationLabelsRequest).withMarshaller((Marshaller)new DetectModerationLabelsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DetectTextResponse detectText(DetectTextRequest detectTextRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectTextResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DetectTextResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectTextRequest).withMarshaller((Marshaller)new DetectTextRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCelebrityInfoResponse getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCelebrityInfoResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetCelebrityInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCelebrityInfoRequest).withMarshaller((Marshaller)new GetCelebrityInfoRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCelebrityRecognitionResponse getCelebrityRecognition(GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCelebrityRecognitionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetCelebrityRecognitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCelebrityRecognitionRequest).withMarshaller((Marshaller)new GetCelebrityRecognitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCelebrityRecognitionIterable getCelebrityRecognitionPaginator(GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetCelebrityRecognitionIterable(this, this.applyPaginatorUserAgent(getCelebrityRecognitionRequest));
    }

    @Override
    public GetContentModerationResponse getContentModeration(GetContentModerationRequest getContentModerationRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContentModerationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetContentModerationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContentModerationRequest).withMarshaller((Marshaller)new GetContentModerationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetContentModerationIterable getContentModerationPaginator(GetContentModerationRequest getContentModerationRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetContentModerationIterable(this, this.applyPaginatorUserAgent(getContentModerationRequest));
    }

    @Override
    public GetFaceDetectionResponse getFaceDetection(GetFaceDetectionRequest getFaceDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFaceDetectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetFaceDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFaceDetectionRequest).withMarshaller((Marshaller)new GetFaceDetectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFaceDetectionIterable getFaceDetectionPaginator(GetFaceDetectionRequest getFaceDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetFaceDetectionIterable(this, this.applyPaginatorUserAgent(getFaceDetectionRequest));
    }

    @Override
    public GetFaceSearchResponse getFaceSearch(GetFaceSearchRequest getFaceSearchRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFaceSearchResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetFaceSearchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFaceSearchRequest).withMarshaller((Marshaller)new GetFaceSearchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFaceSearchIterable getFaceSearchPaginator(GetFaceSearchRequest getFaceSearchRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetFaceSearchIterable(this, this.applyPaginatorUserAgent(getFaceSearchRequest));
    }

    @Override
    public GetLabelDetectionResponse getLabelDetection(GetLabelDetectionRequest getLabelDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLabelDetectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetLabelDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLabelDetectionRequest).withMarshaller((Marshaller)new GetLabelDetectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetLabelDetectionIterable getLabelDetectionPaginator(GetLabelDetectionRequest getLabelDetectionRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetLabelDetectionIterable(this, this.applyPaginatorUserAgent(getLabelDetectionRequest));
    }

    @Override
    public GetPersonTrackingResponse getPersonTracking(GetPersonTrackingRequest getPersonTrackingRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPersonTrackingResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetPersonTrackingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPersonTrackingRequest).withMarshaller((Marshaller)new GetPersonTrackingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPersonTrackingIterable getPersonTrackingPaginator(GetPersonTrackingRequest getPersonTrackingRequest) throws AccessDeniedException, InternalServerErrorException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        return new GetPersonTrackingIterable(this, this.applyPaginatorUserAgent(getPersonTrackingRequest));
    }

    @Override
    public IndexFacesResponse indexFaces(IndexFacesRequest indexFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new IndexFacesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (IndexFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)indexFacesRequest).withMarshaller((Marshaller)new IndexFacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCollectionsResponse listCollections(ListCollectionsRequest listCollectionsRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCollectionsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListCollectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCollectionsRequest).withMarshaller((Marshaller)new ListCollectionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCollectionsIterable listCollectionsPaginator(ListCollectionsRequest listCollectionsRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        return new ListCollectionsIterable(this, this.applyPaginatorUserAgent(listCollectionsRequest));
    }

    @Override
    public ListFacesResponse listFaces(ListFacesRequest listFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFacesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFacesRequest).withMarshaller((Marshaller)new ListFacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListFacesIterable listFacesPaginator(ListFacesRequest listFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        return new ListFacesIterable(this, this.applyPaginatorUserAgent(listFacesRequest));
    }

    @Override
    public ListStreamProcessorsResponse listStreamProcessors(ListStreamProcessorsRequest listStreamProcessorsRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamProcessorsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListStreamProcessorsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamProcessorsRequest).withMarshaller((Marshaller)new ListStreamProcessorsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStreamProcessorsIterable listStreamProcessorsPaginator(ListStreamProcessorsRequest listStreamProcessorsRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, InvalidPaginationTokenException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        return new ListStreamProcessorsIterable(this, this.applyPaginatorUserAgent(listStreamProcessorsRequest));
    }

    @Override
    public RecognizeCelebritiesResponse recognizeCelebrities(RecognizeCelebritiesRequest recognizeCelebritiesRequest) throws InvalidS3ObjectException, InvalidParameterException, InvalidImageFormatException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RecognizeCelebritiesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RecognizeCelebritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recognizeCelebritiesRequest).withMarshaller((Marshaller)new RecognizeCelebritiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SearchFacesResponse searchFaces(SearchFacesRequest searchFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchFacesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SearchFacesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFacesRequest).withMarshaller((Marshaller)new SearchFacesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SearchFacesByImageResponse searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchFacesByImageResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SearchFacesByImageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFacesByImageRequest).withMarshaller((Marshaller)new SearchFacesByImageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartCelebrityRecognitionResponse startCelebrityRecognition(StartCelebrityRecognitionRequest startCelebrityRecognitionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartCelebrityRecognitionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartCelebrityRecognitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startCelebrityRecognitionRequest).withMarshaller((Marshaller)new StartCelebrityRecognitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartContentModerationResponse startContentModeration(StartContentModerationRequest startContentModerationRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartContentModerationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartContentModerationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startContentModerationRequest).withMarshaller((Marshaller)new StartContentModerationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartFaceDetectionResponse startFaceDetection(StartFaceDetectionRequest startFaceDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFaceDetectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartFaceDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFaceDetectionRequest).withMarshaller((Marshaller)new StartFaceDetectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartFaceSearchResponse startFaceSearch(StartFaceSearchRequest startFaceSearchRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFaceSearchResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartFaceSearchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startFaceSearchRequest).withMarshaller((Marshaller)new StartFaceSearchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartLabelDetectionResponse startLabelDetection(StartLabelDetectionRequest startLabelDetectionRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartLabelDetectionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartLabelDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startLabelDetectionRequest).withMarshaller((Marshaller)new StartLabelDetectionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartPersonTrackingResponse startPersonTracking(StartPersonTrackingRequest startPersonTrackingRequest) throws AccessDeniedException, IdempotentParameterMismatchException, InvalidParameterException, InvalidS3ObjectException, InternalServerErrorException, VideoTooLargeException, ProvisionedThroughputExceededException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartPersonTrackingResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartPersonTrackingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startPersonTrackingRequest).withMarshaller((Marshaller)new StartPersonTrackingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartStreamProcessorResponse startStreamProcessor(StartStreamProcessorRequest startStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartStreamProcessorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startStreamProcessorRequest).withMarshaller((Marshaller)new StartStreamProcessorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopStreamProcessorResponse stopStreamProcessor(StopStreamProcessorRequest stopStreamProcessorRequest) throws AccessDeniedException, InternalServerErrorException, ThrottlingException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopStreamProcessorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StopStreamProcessorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopStreamProcessorRequest).withMarshaller((Marshaller)new StopStreamProcessorRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(RekognitionException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidImageFormatException").withModeledClass(InvalidImageFormatException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3ObjectException").withModeledClass(InvalidS3ObjectException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("VideoTooLargeException").withModeledClass(VideoTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withModeledClass(IdempotentParameterMismatchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withModeledClass(ProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageTooLargeException").withModeledClass(ImageTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationTokenException").withModeledClass(InvalidPaginationTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends RekognitionRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RekognitionRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

