/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DetectModerationLabelsRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").isBinary(false).build();
    private static final MarshallingInfo<Float> MINCONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinConfidence").isBinary(false).build();
    private static final DetectModerationLabelsRequestModelMarshaller INSTANCE = new DetectModerationLabelsRequestModelMarshaller();

    private DetectModerationLabelsRequestModelMarshaller() {
    }

    public static DetectModerationLabelsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DetectModerationLabelsRequest detectModerationLabelsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)detectModerationLabelsRequest), (String)"detectModerationLabelsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)detectModerationLabelsRequest.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)detectModerationLabelsRequest.minConfidence(), MINCONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

