/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Celebrity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CelebrityMarshaller {
    private static final MarshallingInfo<List> URLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Urls").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").isBinary(false).build();
    private static final MarshallingInfo<Float> MATCHCONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchConfidence").isBinary(false).build();
    private static final CelebrityMarshaller INSTANCE = new CelebrityMarshaller();

    private CelebrityMarshaller() {
    }

    public static CelebrityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Celebrity celebrity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)celebrity, (String)"celebrity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(celebrity.urls(), URLS_BINDING);
            protocolMarshaller.marshall((Object)celebrity.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)celebrity.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)celebrity.face(), FACE_BINDING);
            protocolMarshaller.marshall((Object)celebrity.matchConfidence(), MATCHCONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

