/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BoundingBoxMarshaller {
    private static final MarshallingInfo<Float> WIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Width").isBinary(false).build();
    private static final MarshallingInfo<Float> HEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Height").isBinary(false).build();
    private static final MarshallingInfo<Float> LEFT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Left").isBinary(false).build();
    private static final MarshallingInfo<Float> TOP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Top").isBinary(false).build();
    private static final BoundingBoxMarshaller INSTANCE = new BoundingBoxMarshaller();

    private BoundingBoxMarshaller() {
    }

    public static BoundingBoxMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BoundingBox boundingBox, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)boundingBox, (String)"boundingBox");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)boundingBox.width(), WIDTH_BINDING);
            protocolMarshaller.marshall((Object)boundingBox.height(), HEIGHT_BINDING);
            protocolMarshaller.marshall((Object)boundingBox.left(), LEFT_BINDING);
            protocolMarshaller.marshall((Object)boundingBox.top(), TOP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

