/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;

public class ListFacesIterable
implements SdkIterable<ListFacesResponse> {
    private final RekognitionClient client;
    private final ListFacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFacesIterable(RekognitionClient client, ListFacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFacesResponseFetcher();
    }

    public Iterator<ListFacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Face> faces() {
        Function<ListFacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.faces() != null) {
                return response.faces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListFacesIterable resume(ListFacesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFacesIterable(this.client, (ListFacesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFacesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListFacesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListFacesResponseFetcher
    implements SyncPageFetcher<ListFacesResponse> {
        private ListFacesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListFacesResponse nextPage(ListFacesResponse previousPage) {
            if (previousPage == null) {
                return ListFacesIterable.this.client.listFaces(ListFacesIterable.this.firstRequest);
            }
            return ListFacesIterable.this.client.listFaces((ListFacesRequest)((Object)ListFacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

