/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.SunglassesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sunglasses
implements StructuredPojo,
ToCopyableBuilder<Builder, Sunglasses> {
    private final Boolean value;
    private final Float confidence;

    private Sunglasses(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    public Boolean value() {
        return this.value;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sunglasses)) {
            return false;
        }
        Sunglasses other = (Sunglasses)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.confidence(), other.confidence());
    }

    public String toString() {
        return ToString.builder((String)"Sunglasses").add("Value", (Object)this.value()).add("Confidence", (Object)this.confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SunglassesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean value;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Sunglasses model) {
            this.value(model.value);
            this.confidence(model.confidence);
        }

        public final Boolean getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Boolean value) {
            this.value = value;
            return this;
        }

        public final void setValue(Boolean value) {
            this.value = value;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public Sunglasses build() {
            return new Sunglasses(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Sunglasses> {
        public Builder value(Boolean var1);

        public Builder confidence(Float var1);
    }
}

