/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFacesByImageResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, SearchFacesByImageResponse> {
    private final BoundingBox searchedFaceBoundingBox;
    private final Float searchedFaceConfidence;
    private final List<FaceMatch> faceMatches;

    private SearchFacesByImageResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceBoundingBox = builder.searchedFaceBoundingBox;
        this.searchedFaceConfidence = builder.searchedFaceConfidence;
        this.faceMatches = builder.faceMatches;
    }

    public BoundingBox searchedFaceBoundingBox() {
        return this.searchedFaceBoundingBox;
    }

    public Float searchedFaceConfidence() {
        return this.searchedFaceConfidence;
    }

    public List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFaceBoundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFaceConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageResponse)) {
            return false;
        }
        SearchFacesByImageResponse other = (SearchFacesByImageResponse)((Object)obj);
        return Objects.equals(this.searchedFaceBoundingBox(), other.searchedFaceBoundingBox()) && Objects.equals(this.searchedFaceConfidence(), other.searchedFaceConfidence()) && Objects.equals(this.faceMatches(), other.faceMatches());
    }

    public String toString() {
        return ToString.builder((String)"SearchFacesByImageResponse").add("SearchedFaceBoundingBox", (Object)this.searchedFaceBoundingBox()).add("SearchedFaceConfidence", (Object)this.searchedFaceConfidence()).add("FaceMatches", this.faceMatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchedFaceBoundingBox": {
                return Optional.ofNullable(clazz.cast(this.searchedFaceBoundingBox()));
            }
            case "SearchedFaceConfidence": {
                return Optional.ofNullable(clazz.cast(this.searchedFaceConfidence()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private BoundingBox searchedFaceBoundingBox;
        private Float searchedFaceConfidence;
        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageResponse model) {
            super(model);
            this.searchedFaceBoundingBox(model.searchedFaceBoundingBox);
            this.searchedFaceConfidence(model.searchedFaceConfidence);
            this.faceMatches(model.faceMatches);
        }

        public final BoundingBox.Builder getSearchedFaceBoundingBox() {
            return this.searchedFaceBoundingBox != null ? this.searchedFaceBoundingBox.toBuilder() : null;
        }

        @Override
        public final Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
            return this;
        }

        public final void setSearchedFaceBoundingBox(BoundingBox.BuilderImpl searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox != null ? searchedFaceBoundingBox.build() : null;
        }

        public final Float getSearchedFaceConfidence() {
            return this.searchedFaceConfidence;
        }

        @Override
        public final Builder searchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
            return this;
        }

        public final void setSearchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (FaceMatch)((FaceMatch.Builder)FaceMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        public SearchFacesByImageResponse build() {
            return new SearchFacesByImageResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, SearchFacesByImageResponse> {
        public Builder searchedFaceBoundingBox(BoundingBox var1);

        default public Builder searchedFaceBoundingBox(Consumer<BoundingBox.Builder> searchedFaceBoundingBox) {
            return this.searchedFaceBoundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(searchedFaceBoundingBox)).build());
        }

        public Builder searchedFaceConfidence(Float var1);

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);

        public Builder faceMatches(Consumer<FaceMatch.Builder> ... var1);
    }
}

