/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.transform.FaceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Face
implements StructuredPojo,
ToCopyableBuilder<Builder, Face> {
    private final String faceId;
    private final BoundingBox boundingBox;
    private final String imageId;
    private final String externalImageId;
    private final Float confidence;

    private Face(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.boundingBox = builder.boundingBox;
        this.imageId = builder.imageId;
        this.externalImageId = builder.externalImageId;
        this.confidence = builder.confidence;
    }

    public String faceId() {
        return this.faceId;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public String imageId() {
        return this.imageId;
    }

    public String externalImageId() {
        return this.externalImageId;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face)obj;
        return Objects.equals(this.faceId(), other.faceId()) && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.externalImageId(), other.externalImageId()) && Objects.equals(this.confidence(), other.confidence());
    }

    public String toString() {
        return ToString.builder((String)"Face").add("FaceId", (Object)this.faceId()).add("BoundingBox", (Object)this.boundingBox()).add("ImageId", (Object)this.imageId()).add("ExternalImageId", (Object)this.externalImageId()).add("Confidence", (Object)this.confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceId": {
                return Optional.ofNullable(clazz.cast(this.faceId()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ExternalImageId": {
                return Optional.ofNullable(clazz.cast(this.externalImageId()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String faceId;
        private BoundingBox boundingBox;
        private String imageId;
        private String externalImageId;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Face model) {
            this.faceId(model.faceId);
            this.boundingBox(model.boundingBox);
            this.imageId(model.imageId);
            this.externalImageId(model.externalImageId);
            this.confidence(model.confidence);
        }

        public final String getFaceId() {
            return this.faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public Face build() {
            return new Face(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Face> {
        public Builder faceId(String var1);

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder imageId(String var1);

        public Builder externalImageId(String var1);

        public Builder confidence(Float var1);
    }
}

