/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DetectLabelsRequest> {
    private final Image image;
    private final Integer maxLabels;
    private final Float minConfidence;

    private DetectLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.maxLabels = builder.maxLabels;
        this.minConfidence = builder.minConfidence;
    }

    public Image image() {
        return this.image;
    }

    public Integer maxLabels() {
        return this.maxLabels;
    }

    public Float minConfidence() {
        return this.minConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsRequest)) {
            return false;
        }
        DetectLabelsRequest other = (DetectLabelsRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.maxLabels(), other.maxLabels()) && Objects.equals(this.minConfidence(), other.minConfidence());
    }

    public String toString() {
        return ToString.builder((String)"DetectLabelsRequest").add("Image", (Object)this.image()).add("MaxLabels", (Object)this.maxLabels()).add("MinConfidence", (Object)this.minConfidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MaxLabels": {
                return Optional.ofNullable(clazz.cast(this.maxLabels()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image image;
        private Integer maxLabels;
        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsRequest model) {
            super(model);
            this.image(model.image);
            this.maxLabels(model.maxLabels);
            this.minConfidence(model.minConfidence);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getMaxLabels() {
            return this.maxLabels;
        }

        @Override
        public final Builder maxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
            return this;
        }

        public final void setMaxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectLabelsRequest build() {
            return new DetectLabelsRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, DetectLabelsRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder maxLabels(Integer var1);

        public Builder minConfidence(Float var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

