/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.AccessDeniedException;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.ImageTooLargeException;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.InternalServerErrorException;
import software.amazon.awssdk.services.rekognition.model.InvalidImageFormatException;
import software.amazon.awssdk.services.rekognition.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.rekognition.model.InvalidParameterException;
import software.amazon.awssdk.services.rekognition.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionException;
import software.amazon.awssdk.services.rekognition.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ThrottlingException;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesResponseUnmarshaller;

@SdkInternalApi
final class DefaultRekognitionAsyncClient
implements RekognitionAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultRekognitionAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<CompareFacesResponse> compareFaces(CompareFacesRequest compareFacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CompareFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CompareFacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)compareFacesRequest));
    }

    @Override
    public CompletableFuture<CreateCollectionResponse> createCollection(CreateCollectionRequest createCollectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateCollectionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateCollectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createCollectionRequest));
    }

    @Override
    public CompletableFuture<DeleteCollectionResponse> deleteCollection(DeleteCollectionRequest deleteCollectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteCollectionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteCollectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteCollectionRequest));
    }

    @Override
    public CompletableFuture<DeleteFacesResponse> deleteFaces(DeleteFacesRequest deleteFacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteFacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteFacesRequest));
    }

    @Override
    public CompletableFuture<DetectFacesResponse> detectFaces(DetectFacesRequest detectFacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DetectFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectFacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)detectFacesRequest));
    }

    @Override
    public CompletableFuture<DetectLabelsResponse> detectLabels(DetectLabelsRequest detectLabelsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DetectLabelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectLabelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)detectLabelsRequest));
    }

    @Override
    public CompletableFuture<DetectModerationLabelsResponse> detectModerationLabels(DetectModerationLabelsRequest detectModerationLabelsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DetectModerationLabelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetectModerationLabelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)detectModerationLabelsRequest));
    }

    @Override
    public CompletableFuture<GetCelebrityInfoResponse> getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetCelebrityInfoResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCelebrityInfoRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getCelebrityInfoRequest));
    }

    @Override
    public CompletableFuture<IndexFacesResponse> indexFaces(IndexFacesRequest indexFacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new IndexFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new IndexFacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)indexFacesRequest));
    }

    @Override
    public CompletableFuture<ListCollectionsResponse> listCollections(ListCollectionsRequest listCollectionsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListCollectionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListCollectionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listCollectionsRequest));
    }

    @Override
    public CompletableFuture<ListFacesResponse> listFaces(ListFacesRequest listFacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListFacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listFacesRequest));
    }

    @Override
    public CompletableFuture<RecognizeCelebritiesResponse> recognizeCelebrities(RecognizeCelebritiesRequest recognizeCelebritiesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RecognizeCelebritiesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RecognizeCelebritiesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)recognizeCelebritiesRequest));
    }

    @Override
    public CompletableFuture<SearchFacesResponse> searchFaces(SearchFacesRequest searchFacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SearchFacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchFacesRequest));
    }

    @Override
    public CompletableFuture<SearchFacesByImageResponse> searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchFacesByImageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SearchFacesByImageRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchFacesByImageRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(RekognitionException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidImageFormatException").withModeledClass(InvalidImageFormatException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withModeledClass(ProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageTooLargeException").withModeledClass(ImageTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationTokenException").withModeledClass(InvalidPaginationTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3ObjectException").withModeledClass(InvalidS3ObjectException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

