/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class FmsServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "fms";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"fips-af-south-1", (Object)"fms-fips.af-south-1.amazonaws.com").put((Object)"fips-ap-east-1", (Object)"fms-fips.ap-east-1.amazonaws.com").put((Object)"fips-ap-northeast-1", (Object)"fms-fips.ap-northeast-1.amazonaws.com").put((Object)"fips-ap-northeast-2", (Object)"fms-fips.ap-northeast-2.amazonaws.com").put((Object)"fips-ap-south-1", (Object)"fms-fips.ap-south-1.amazonaws.com").put((Object)"fips-ap-southeast-1", (Object)"fms-fips.ap-southeast-1.amazonaws.com").put((Object)"fips-ap-southeast-2", (Object)"fms-fips.ap-southeast-2.amazonaws.com").put((Object)"fips-ca-central-1", (Object)"fms-fips.ca-central-1.amazonaws.com").put((Object)"fips-eu-central-1", (Object)"fms-fips.eu-central-1.amazonaws.com").put((Object)"fips-eu-south-1", (Object)"fms-fips.eu-south-1.amazonaws.com").put((Object)"fips-eu-west-1", (Object)"fms-fips.eu-west-1.amazonaws.com").put((Object)"fips-eu-west-2", (Object)"fms-fips.eu-west-2.amazonaws.com").put((Object)"fips-eu-west-3", (Object)"fms-fips.eu-west-3.amazonaws.com").put((Object)"fips-me-south-1", (Object)"fms-fips.me-south-1.amazonaws.com").put((Object)"fips-sa-east-1", (Object)"fms-fips.sa-east-1.amazonaws.com").put((Object)"fips-us-east-1", (Object)"fms-fips.us-east-1.amazonaws.com").put((Object)"fips-us-east-2", (Object)"fms-fips.us-east-2.amazonaws.com").put((Object)"fips-us-west-1", (Object)"fms-fips.us-west-1.amazonaws.com").put((Object)"fips-us-west-2", (Object)"fms-fips.us-west-2.amazonaws.com").put((Object)"fips-us-gov-east-1", (Object)"fms-fips.us-gov-east-1.amazonaws.com").put((Object)"fips-us-gov-west-1", (Object)"fms-fips.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-af-south-1"), Region.of("fips-ap-east-1"), Region.of("fips-ap-northeast-1"), Region.of("fips-ap-northeast-2"), Region.of("fips-ap-south-1"), Region.of("fips-ap-southeast-1"), Region.of("fips-ap-southeast-2"), Region.of("fips-ca-central-1"), Region.of("fips-eu-central-1"), Region.of("fips-eu-south-1"), Region.of("fips-eu-west-1"), Region.of("fips-eu-west-2"), Region.of("fips-eu-west-3"), Region.of("fips-me-south-1"), Region.of("fips-sa-east-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("me-south-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("fips-us-gov-east-1"), Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"fips-af-south-1", (Object)"af-south-1").put((Object)"fips-ap-east-1", (Object)"ap-east-1").put((Object)"fips-ap-northeast-1", (Object)"ap-northeast-1").put((Object)"fips-ap-northeast-2", (Object)"ap-northeast-2").put((Object)"fips-ap-south-1", (Object)"ap-south-1").put((Object)"fips-ap-southeast-1", (Object)"ap-southeast-1").put((Object)"fips-ap-southeast-2", (Object)"ap-southeast-2").put((Object)"fips-ca-central-1", (Object)"ca-central-1").put((Object)"fips-eu-central-1", (Object)"eu-central-1").put((Object)"fips-eu-south-1", (Object)"eu-south-1").put((Object)"fips-eu-west-1", (Object)"eu-west-1").put((Object)"fips-eu-west-2", (Object)"eu-west-2").put((Object)"fips-eu-west-3", (Object)"eu-west-3").put((Object)"fips-me-south-1", (Object)"me-south-1").put((Object)"fips-sa-east-1", (Object)"sa-east-1").put((Object)"fips-us-east-1", (Object)"us-east-1").put((Object)"fips-us-east-2", (Object)"us-east-2").put((Object)"fips-us-west-1", (Object)"us-west-1").put((Object)"fips-us-west-2", (Object)"us-west-2").put((Object)"fips-us-gov-east-1", (Object)"us-gov-east-1").put((Object)"fips-us-gov-west-1", (Object)"us-gov-west-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-us-gov", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

