/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUsageLimitResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<UpdateUsageLimitResponse.Builder, UpdateUsageLimitResponse> {
    private static final SdkField<UsageLimit> USAGE_LIMIT_FIELD = SdkField.<UsageLimit> builder(MarshallingType.SDK_POJO)
            .memberName("usageLimit").getter(getter(UpdateUsageLimitResponse::usageLimit)).setter(setter(Builder::usageLimit))
            .constructor(UsageLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final UsageLimit usageLimit;

    private UpdateUsageLimitResponse(BuilderImpl builder) {
        super(builder);
        this.usageLimit = builder.usageLimit;
    }

    /**
     * <p>
     * The updated usage limit object.
     * </p>
     * 
     * @return The updated usage limit object.
     */
    public final UsageLimit usageLimit() {
        return usageLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUsageLimitResponse)) {
            return false;
        }
        UpdateUsageLimitResponse other = (UpdateUsageLimitResponse) obj;
        return Objects.equals(usageLimit(), other.usageLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUsageLimitResponse").add("UsageLimit", usageLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usageLimit":
            return Optional.ofNullable(clazz.cast(usageLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usageLimit", USAGE_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUsageLimitResponse, T> g) {
        return obj -> g.apply((UpdateUsageLimitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUsageLimitResponse> {
        /**
         * <p>
         * The updated usage limit object.
         * </p>
         * 
         * @param usageLimit
         *        The updated usage limit object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimit(UsageLimit usageLimit);

        /**
         * <p>
         * The updated usage limit object.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageLimit.Builder} avoiding the need to
         * create one manually via {@link UsageLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageLimit.Builder#build()} is called immediately and its result
         * is passed to {@link #usageLimit(UsageLimit)}.
         * 
         * @param usageLimit
         *        a consumer that will call methods on {@link UsageLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageLimit(UsageLimit)
         */
        default Builder usageLimit(Consumer<UsageLimit.Builder> usageLimit) {
            return usageLimit(UsageLimit.builder().applyMutation(usageLimit).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private UsageLimit usageLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUsageLimitResponse model) {
            super(model);
            usageLimit(model.usageLimit);
        }

        public final UsageLimit.Builder getUsageLimit() {
            return usageLimit != null ? usageLimit.toBuilder() : null;
        }

        public final void setUsageLimit(UsageLimit.BuilderImpl usageLimit) {
            this.usageLimit = usageLimit != null ? usageLimit.build() : null;
        }

        @Override
        public final Builder usageLimit(UsageLimit usageLimit) {
            this.usageLimit = usageLimit;
            return this;
        }

        @Override
        public UpdateUsageLimitResponse build() {
            return new UpdateUsageLimitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
