/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The class of offering for the reservation. The offering class determines the payment schedule for the reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationOffering.Builder, ReservationOffering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(ReservationOffering::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("duration").getter(getter(ReservationOffering::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<Double> HOURLY_CHARGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("hourlyCharge").getter(getter(ReservationOffering::hourlyCharge)).setter(setter(Builder::hourlyCharge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hourlyCharge").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(ReservationOffering::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringType").getter(getter(ReservationOffering::offeringTypeAsString))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()).build();

    private static final SdkField<Double> UPFRONT_CHARGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("upfrontCharge").getter(getter(ReservationOffering::upfrontCharge))
            .setter(setter(Builder::upfrontCharge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontCharge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            DURATION_FIELD, HOURLY_CHARGE_FIELD, OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, UPFRONT_CHARGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final Integer duration;

    private final Double hourlyCharge;

    private final String offeringId;

    private final String offeringType;

    private final Double upfrontCharge;

    private ReservationOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hourlyCharge = builder.hourlyCharge;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.upfrontCharge = builder.upfrontCharge;
    }

    /**
     * <p>
     * The currency code for the offering.
     * </p>
     * 
     * @return The currency code for the offering.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The duration, in seconds, for which the reservation reserves the RPUs.
     * </p>
     * 
     * @return The duration, in seconds, for which the reservation reserves the RPUs.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The rate you are charged for each hour the reservation is active.
     * </p>
     * 
     * @return The rate you are charged for each hour the reservation is active.
     */
    public final Double hourlyCharge() {
        return hourlyCharge;
    }

    /**
     * <p>
     * The offering identifier.
     * </p>
     * 
     * @return The offering identifier.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * Determines the payment schedule for the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return Determines the payment schedule for the reservation.
     * @see OfferingType
     */
    public final OfferingType offeringType() {
        return OfferingType.fromValue(offeringType);
    }

    /**
     * <p>
     * Determines the payment schedule for the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return Determines the payment schedule for the reservation.
     * @see OfferingType
     */
    public final String offeringTypeAsString() {
        return offeringType;
    }

    /**
     * <p>
     * The up-front price you are charged for the reservation.
     * </p>
     * 
     * @return The up-front price you are charged for the reservation.
     */
    public final Double upfrontCharge() {
        return upfrontCharge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCharge());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCharge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationOffering)) {
            return false;
        }
        ReservationOffering other = (ReservationOffering) obj;
        return Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(duration(), other.duration())
                && Objects.equals(hourlyCharge(), other.hourlyCharge()) && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(offeringTypeAsString(), other.offeringTypeAsString())
                && Objects.equals(upfrontCharge(), other.upfrontCharge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservationOffering").add("CurrencyCode", currencyCode()).add("Duration", duration())
                .add("HourlyCharge", hourlyCharge()).add("OfferingId", offeringId()).add("OfferingType", offeringTypeAsString())
                .add("UpfrontCharge", upfrontCharge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "hourlyCharge":
            return Optional.ofNullable(clazz.cast(hourlyCharge()));
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "offeringType":
            return Optional.ofNullable(clazz.cast(offeringTypeAsString()));
        case "upfrontCharge":
            return Optional.ofNullable(clazz.cast(upfrontCharge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("duration", DURATION_FIELD);
        map.put("hourlyCharge", HOURLY_CHARGE_FIELD);
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("offeringType", OFFERING_TYPE_FIELD);
        map.put("upfrontCharge", UPFRONT_CHARGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationOffering, T> g) {
        return obj -> g.apply((ReservationOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationOffering> {
        /**
         * <p>
         * The currency code for the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The duration, in seconds, for which the reservation reserves the RPUs.
         * </p>
         * 
         * @param duration
         *        The duration, in seconds, for which the reservation reserves the RPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The rate you are charged for each hour the reservation is active.
         * </p>
         * 
         * @param hourlyCharge
         *        The rate you are charged for each hour the reservation is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCharge(Double hourlyCharge);

        /**
         * <p>
         * The offering identifier.
         * </p>
         * 
         * @param offeringId
         *        The offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * Determines the payment schedule for the reservation.
         * </p>
         * 
         * @param offeringType
         *        Determines the payment schedule for the reservation.
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * Determines the payment schedule for the reservation.
         * </p>
         * 
         * @param offeringType
         *        Determines the payment schedule for the reservation.
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder offeringType(OfferingType offeringType);

        /**
         * <p>
         * The up-front price you are charged for the reservation.
         * </p>
         * 
         * @param upfrontCharge
         *        The up-front price you are charged for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCharge(Double upfrontCharge);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private Double hourlyCharge;

        private String offeringId;

        private String offeringType;

        private Double upfrontCharge;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationOffering model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            hourlyCharge(model.hourlyCharge);
            offeringId(model.offeringId);
            offeringType(model.offeringType);
            upfrontCharge(model.upfrontCharge);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getHourlyCharge() {
            return hourlyCharge;
        }

        public final void setHourlyCharge(Double hourlyCharge) {
            this.hourlyCharge = hourlyCharge;
        }

        @Override
        public final Builder hourlyCharge(Double hourlyCharge) {
            this.hourlyCharge = hourlyCharge;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final Double getUpfrontCharge() {
            return upfrontCharge;
        }

        public final void setUpfrontCharge(Double upfrontCharge) {
            this.upfrontCharge = upfrontCharge;
        }

        @Override
        public final Builder upfrontCharge(Double upfrontCharge) {
            this.upfrontCharge = upfrontCharge;
            return this;
        }

        @Override
        public ReservationOffering build() {
            return new ReservationOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
