/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScheduledActionResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<GetScheduledActionResponse.Builder, GetScheduledActionResponse> {
    private static final SdkField<ScheduledActionResponse> SCHEDULED_ACTION_FIELD = SdkField
            .<ScheduledActionResponse> builder(MarshallingType.SDK_POJO).memberName("scheduledAction")
            .getter(getter(GetScheduledActionResponse::scheduledAction)).setter(setter(Builder::scheduledAction))
            .constructor(ScheduledActionResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ScheduledActionResponse scheduledAction;

    private GetScheduledActionResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledAction = builder.scheduledAction;
    }

    /**
     * <p>
     * The returned scheduled action object.
     * </p>
     * 
     * @return The returned scheduled action object.
     */
    public final ScheduledActionResponse scheduledAction() {
        return scheduledAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduledActionResponse)) {
            return false;
        }
        GetScheduledActionResponse other = (GetScheduledActionResponse) obj;
        return Objects.equals(scheduledAction(), other.scheduledAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScheduledActionResponse").add("ScheduledAction", scheduledAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledAction":
            return Optional.ofNullable(clazz.cast(scheduledAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scheduledAction", SCHEDULED_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduledActionResponse, T> g) {
        return obj -> g.apply((GetScheduledActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetScheduledActionResponse> {
        /**
         * <p>
         * The returned scheduled action object.
         * </p>
         * 
         * @param scheduledAction
         *        The returned scheduled action object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAction(ScheduledActionResponse scheduledAction);

        /**
         * <p>
         * The returned scheduled action object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledActionResponse.Builder} avoiding
         * the need to create one manually via {@link ScheduledActionResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledActionResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #scheduledAction(ScheduledActionResponse)}.
         * 
         * @param scheduledAction
         *        a consumer that will call methods on {@link ScheduledActionResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledAction(ScheduledActionResponse)
         */
        default Builder scheduledAction(Consumer<ScheduledActionResponse.Builder> scheduledAction) {
            return scheduledAction(ScheduledActionResponse.builder().applyMutation(scheduledAction).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private ScheduledActionResponse scheduledAction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduledActionResponse model) {
            super(model);
            scheduledAction(model.scheduledAction);
        }

        public final ScheduledActionResponse.Builder getScheduledAction() {
            return scheduledAction != null ? scheduledAction.toBuilder() : null;
        }

        public final void setScheduledAction(ScheduledActionResponse.BuilderImpl scheduledAction) {
            this.scheduledAction = scheduledAction != null ? scheduledAction.build() : null;
        }

        @Override
        public final Builder scheduledAction(ScheduledActionResponse scheduledAction) {
            this.scheduledAction = scheduledAction;
            return this;
        }

        @Override
        public GetScheduledActionResponse build() {
            return new GetScheduledActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
