/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.redshiftserverless.internal.RedshiftServerlessServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.redshiftserverless.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.redshiftserverless.model.AccessDeniedException;
import software.amazon.awssdk.services.redshiftserverless.model.ConflictException;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateReservationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateReservationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotCopyConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotCopyConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotCopyConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DryRunException;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetIdentityCenterAuthTokenRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetIdentityCenterAuthTokenResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationOfferingRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationOfferingResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetReservationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTrackRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTrackResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.InsufficientCapacityException;
import software.amazon.awssdk.services.redshiftserverless.model.InternalServerException;
import software.amazon.awssdk.services.redshiftserverless.model.InvalidPaginationException;
import software.amazon.awssdk.services.redshiftserverless.model.Ipv6CidrBlockNotFoundException;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListManagedWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListScheduledActionsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotCopyConfigurationsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTracksResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessException;
import software.amazon.awssdk.services.redshiftserverless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ThrottlingException;
import software.amazon.awssdk.services.redshiftserverless.model.TooManyTagsException;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateLakehouseConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateLakehouseConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateScheduledActionRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateScheduledActionResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotCopyConfigurationResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ValidationException;
import software.amazon.awssdk.services.redshiftserverless.transform.ConvertRecoveryPointToSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateReservationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateSnapshotCopyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteSnapshotCopyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetIdentityCenterAuthTokenRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetReservationOfferingRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetReservationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetTrackRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListCustomDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListManagedWorkgroupsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListReservationOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListSnapshotCopyConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTracksRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListUsageLimitsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListWorkgroupsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreFromRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreTableFromRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreTableFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateLakehouseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateSnapshotCopyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateWorkgroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link RedshiftServerlessAsyncClient}.
 *
 * @see RedshiftServerlessAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRedshiftServerlessAsyncClient implements RedshiftServerlessAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedshiftServerlessAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRedshiftServerlessAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Redshift_Serverless" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery-points.html">Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     * @return A Java Future containing the result of the ConvertRecoveryPointToSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConvertRecoveryPointToSnapshotResponse> convertRecoveryPointToSnapshot(
            ConvertRecoveryPointToSnapshotRequest convertRecoveryPointToSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(convertRecoveryPointToSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                convertRecoveryPointToSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConvertRecoveryPointToSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConvertRecoveryPointToSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConvertRecoveryPointToSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConvertRecoveryPointToSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConvertRecoveryPointToSnapshotRequest, ConvertRecoveryPointToSnapshotResponse>()
                            .withOperationName("ConvertRecoveryPointToSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConvertRecoveryPointToSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(convertRecoveryPointToSnapshotRequest));
            CompletableFuture<ConvertRecoveryPointToSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom domain association for Amazon Redshift Serverless.
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     * @return A Java Future containing the result of the CreateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(
            CreateCustomDomainAssociationRequest createCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomDomainAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomDomainAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomDomainAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomDomainAssociationRequest, CreateCustomDomainAssociationResponse>()
                            .withOperationName("CreateCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomDomainAssociationRequest));
            CompletableFuture<CreateCustomDomainAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            CreateEndpointAccessRequest createEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointAccessRequest, CreateEndpointAccessResponse>()
                            .withOperationName("CreateEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointAccessRequest));
            CompletableFuture<CreateEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param createNamespaceRequest
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest createNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNamespaceRequest, CreateNamespaceResponse>()
                            .withOperationName("CreateNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNamespaceRequest));
            CompletableFuture<CreateNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless reservation, which gives you the option to commit to a specified number of
     * Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
     * </p>
     *
     * @param createReservationRequest
     * @return A Java Future containing the result of the CreateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReservationResponse> createReservation(CreateReservationRequest createReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReservationRequest, CreateReservationResponse>()
                            .withOperationName("CreateReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReservationRequest));
            CompletableFuture<CreateReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For
     * example, you can create a schedule of when to run the <code>CreateSnapshot</code> API operation.
     * </p>
     *
     * @param createScheduledActionRequest
     * @return A Java Future containing the result of the CreateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateScheduledActionResponse> createScheduledAction(
            CreateScheduledActionRequest createScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScheduledAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateScheduledActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateScheduledActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateScheduledActionRequest, CreateScheduledActionResponse>()
                            .withOperationName("CreateScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createScheduledActionRequest));
            CompletableFuture<CreateScheduledActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery-points.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotRequest));
            CompletableFuture<CreateSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.
     * </p>
     *
     * @param createSnapshotCopyConfigurationRequest
     * @return A Java Future containing the result of the CreateSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotCopyConfigurationResponse> createSnapshotCopyConfiguration(
            CreateSnapshotCopyConfigurationRequest createSnapshotCopyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotCopyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSnapshotCopyConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshotCopyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSnapshotCopyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSnapshotCopyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateSnapshotCopyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotCopyConfigurationRequest, CreateSnapshotCopyConfigurationResponse>()
                            .withOperationName("CreateSnapshotCopyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotCopyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotCopyConfigurationRequest));
            CompletableFuture<CreateSnapshotCopyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUsageLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsageLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUsageLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUsageLimitRequest, CreateUsageLimitResponse>()
                            .withOperationName("CreateUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUsageLimitRequest));
            CompletableFuture<CreateUsageLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     * <p>
     * VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
     * reaching or being reached from the internet through internet gateways and egress-only internet gateways. If a
     * workgroup is in an account with VPC BPA turned on, the following capabilities are blocked:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating a public access workgroup
     * </p>
     * </li>
     * <li>
     * <p>
     * Modifying a private workgroup to public
     * </p>
     * </li>
     * <li>
     * <p>
     * Adding a subnet with VPC BPA turned on to the workgroup when the workgroup is public
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createWorkgroupRequest
     * @return A Java Future containing the result of the CreateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkgroupResponse> createWorkgroup(CreateWorkgroupRequest createWorkgroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkgroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkgroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkgroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateWorkgroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkgroupRequest, CreateWorkgroupResponse>()
                            .withOperationName("CreateWorkgroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkgroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorkgroupRequest));
            CompletableFuture<CreateWorkgroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom domain association for Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     * @return A Java Future containing the result of the DeleteCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(
            DeleteCustomDomainAssociationRequest deleteCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomDomainAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomDomainAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomDomainAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomDomainAssociationRequest, DeleteCustomDomainAssociationResponse>()
                            .withOperationName("DeleteCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomDomainAssociationRequest));
            CompletableFuture<DeleteCustomDomainAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            DeleteEndpointAccessRequest deleteEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointAccessRequest, DeleteEndpointAccessResponse>()
                            .withOperationName("DeleteEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointAccessRequest));
            CompletableFuture<DeleteEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                            .withOperationName("DeleteNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNamespaceRequest));
            CompletableFuture<DeleteNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScheduledAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteScheduledActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteScheduledActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteScheduledActionRequest, DeleteScheduledActionResponse>()
                            .withOperationName("DeleteScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteScheduledActionRequest));
            CompletableFuture<DeleteScheduledActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                            .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotRequest));
            CompletableFuture<DeleteSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a snapshot copy configuration
     * </p>
     *
     * @param deleteSnapshotCopyConfigurationRequest
     * @return A Java Future containing the result of the DeleteSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotCopyConfigurationResponse> deleteSnapshotCopyConfiguration(
            DeleteSnapshotCopyConfigurationRequest deleteSnapshotCopyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotCopyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSnapshotCopyConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshotCopyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSnapshotCopyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSnapshotCopyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteSnapshotCopyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotCopyConfigurationRequest, DeleteSnapshotCopyConfigurationResponse>()
                            .withOperationName("DeleteSnapshotCopyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotCopyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotCopyConfigurationRequest));
            CompletableFuture<DeleteSnapshotCopyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUsageLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsageLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUsageLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUsageLimitRequest, DeleteUsageLimitResponse>()
                            .withOperationName("DeleteUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUsageLimitRequest));
            CompletableFuture<DeleteUsageLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     *
     * @param deleteWorkgroupRequest
     * @return A Java Future containing the result of the DeleteWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkgroupResponse> deleteWorkgroup(DeleteWorkgroupRequest deleteWorkgroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkgroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkgroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkgroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteWorkgroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkgroupRequest, DeleteWorkgroupResponse>()
                            .withOperationName("DeleteWorkgroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkgroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorkgroupRequest));
            CompletableFuture<DeleteWorkgroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached
     * that allows access to all necessary actions and resources.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource dbname for
     * the specified database name.
     * </p>
     *
     * @param getCredentialsRequest
     * @return A Java Future containing the result of the GetCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCredentialsResponse> getCredentials(GetCredentialsRequest getCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCredentialsRequest, GetCredentialsResponse>()
                            .withOperationName("GetCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCredentialsRequest));
            CompletableFuture<GetCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific custom domain association.
     * </p>
     *
     * @param getCustomDomainAssociationRequest
     * @return A Java Future containing the result of the GetCustomDomainAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCustomDomainAssociationResponse> getCustomDomainAssociation(
            GetCustomDomainAssociationRequest getCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCustomDomainAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCustomDomainAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCustomDomainAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCustomDomainAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCustomDomainAssociationRequest, GetCustomDomainAssociationResponse>()
                            .withOperationName("GetCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCustomDomainAssociationRequest));
            CompletableFuture<GetCustomDomainAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     *
     * @param getEndpointAccessRequest
     * @return A Java Future containing the result of the GetEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEndpointAccessResponse> getEndpointAccess(GetEndpointAccessRequest getEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEndpointAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEndpointAccessRequest, GetEndpointAccessResponse>()
                            .withOperationName("GetEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEndpointAccessRequest));
            CompletableFuture<GetEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an Identity Center authentication token for accessing Amazon Redshift Serverless workgroups.
     * </p>
     * <p>
     * The token provides secure access to data within the specified workgroups using Identity Center identity
     * propagation. The token expires after a specified duration and must be refreshed for continued access.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetIdentityCenterAuthToken must have appropriate
     * permissions to access the specified workgroups and Identity Center integration must be configured for the
     * workgroups.
     * </p>
     *
     * @param getIdentityCenterAuthTokenRequest
     * @return A Java Future containing the result of the GetIdentityCenterAuthToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DryRunException This exception is thrown when the request was successful, but dry run was enabled so
     *         no action was taken.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetIdentityCenterAuthToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetIdentityCenterAuthToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdentityCenterAuthTokenResponse> getIdentityCenterAuthToken(
            GetIdentityCenterAuthTokenRequest getIdentityCenterAuthTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdentityCenterAuthTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdentityCenterAuthTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdentityCenterAuthToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdentityCenterAuthTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdentityCenterAuthTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetIdentityCenterAuthTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdentityCenterAuthTokenRequest, GetIdentityCenterAuthTokenResponse>()
                            .withOperationName("GetIdentityCenterAuthToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdentityCenterAuthTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdentityCenterAuthTokenRequest));
            CompletableFuture<GetIdentityCenterAuthTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param getNamespaceRequest
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest getNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNamespaceRequest, GetNamespaceResponse>()
                            .withOperationName("GetNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getNamespaceRequest));
            CompletableFuture<GetNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     *
     * @param getRecoveryPointRequest
     * @return A Java Future containing the result of the GetRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecoveryPointResponse> getRecoveryPoint(GetRecoveryPointRequest getRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecoveryPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecoveryPointRequest, GetRecoveryPointResponse>()
                            .withOperationName("GetRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRecoveryPointRequest));
            CompletableFuture<GetRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an Amazon Redshift Serverless reservation. A reservation gives you the option to commit to a specified
     * number of Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
     * </p>
     *
     * @param getReservationRequest
     * @return A Java Future containing the result of the GetReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReservationResponse> getReservation(GetReservationRequest getReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReservationRequest, GetReservationResponse>()
                            .withOperationName("GetReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getReservationRequest));
            CompletableFuture<GetReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the reservation offering. The offering determines the payment schedule for the reservation.
     * </p>
     *
     * @param getReservationOfferingRequest
     * @return A Java Future containing the result of the GetReservationOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetReservationOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetReservationOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReservationOfferingResponse> getReservationOffering(
            GetReservationOfferingRequest getReservationOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReservationOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReservationOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReservationOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReservationOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReservationOfferingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetReservationOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReservationOfferingRequest, GetReservationOfferingResponse>()
                            .withOperationName("GetReservationOffering").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReservationOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getReservationOfferingRequest));
            CompletableFuture<GetReservationOfferingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                            .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePolicyRequest));
            CompletableFuture<GetResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a scheduled action.
     * </p>
     *
     * @param getScheduledActionRequest
     * @return A Java Future containing the result of the GetScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetScheduledActionResponse> getScheduledAction(GetScheduledActionRequest getScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetScheduledAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetScheduledActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetScheduledActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetScheduledActionRequest, GetScheduledActionResponse>()
                            .withOperationName("GetScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getScheduledActionRequest));
            CompletableFuture<GetScheduledActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSnapshotResponse> getSnapshot(GetSnapshotRequest getSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSnapshotRequest, GetSnapshotResponse>()
                            .withOperationName("GetSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSnapshotRequest));
            CompletableFuture<GetSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     *
     * @param getTableRestoreStatusRequest
     * @return A Java Future containing the result of the GetTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTableRestoreStatusResponse> getTableRestoreStatus(
            GetTableRestoreStatusRequest getTableRestoreStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTableRestoreStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTableRestoreStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableRestoreStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTableRestoreStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTableRestoreStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTableRestoreStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTableRestoreStatusRequest, GetTableRestoreStatusResponse>()
                            .withOperationName("GetTableRestoreStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTableRestoreStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTableRestoreStatusRequest));
            CompletableFuture<GetTableRestoreStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the Redshift Serverless version for a specified track.
     * </p>
     *
     * @param getTrackRequest
     * @return A Java Future containing the result of the GetTrack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DryRunException This exception is thrown when the request was successful, but dry run was enabled so
     *         no action was taken.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTrack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTrack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrackResponse> getTrack(GetTrackRequest getTrackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTrackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTrackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrackRequest, GetTrackResponse>().withOperationName("GetTrack")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrackRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTrackRequest));
            CompletableFuture<GetTrackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     *
     * @param getUsageLimitRequest
     * @return A Java Future containing the result of the GetUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUsageLimitResponse> getUsageLimit(GetUsageLimitRequest getUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsageLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsageLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsageLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageLimitRequest, GetUsageLimitResponse>()
                            .withOperationName("GetUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsageLimitRequest));
            CompletableFuture<GetUsageLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     *
     * @param getWorkgroupRequest
     * @return A Java Future containing the result of the GetWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkgroupResponse> getWorkgroup(GetWorkgroupRequest getWorkgroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkgroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkgroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetWorkgroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetWorkgroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkgroupRequest, GetWorkgroupResponse>()
                            .withOperationName("GetWorkgroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkgroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorkgroupRequest));
            CompletableFuture<GetWorkgroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists custom domain associations for Amazon Redshift Serverless.
     * </p>
     *
     * @param listCustomDomainAssociationsRequest
     * @return A Java Future containing the result of the ListCustomDomainAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListCustomDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomDomainAssociationsResponse> listCustomDomainAssociations(
            ListCustomDomainAssociationsRequest listCustomDomainAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomDomainAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomDomainAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomDomainAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomDomainAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomDomainAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCustomDomainAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomDomainAssociationsRequest, ListCustomDomainAssociationsResponse>()
                            .withOperationName("ListCustomDomainAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomDomainAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomDomainAssociationsRequest));
            CompletableFuture<ListCustomDomainAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return A Java Future containing the result of the ListEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEndpointAccessResponse> listEndpointAccess(ListEndpointAccessRequest listEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEndpointAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEndpointAccessRequest, ListEndpointAccessResponse>()
                            .withOperationName("ListEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEndpointAccessRequest));
            CompletableFuture<ListEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a list of specified managed workgroups in your account.
     * </p>
     *
     * @param listManagedWorkgroupsRequest
     * @return A Java Future containing the result of the ListManagedWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListManagedWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListManagedWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListManagedWorkgroupsResponse> listManagedWorkgroups(
            ListManagedWorkgroupsRequest listManagedWorkgroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedWorkgroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedWorkgroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedWorkgroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListManagedWorkgroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListManagedWorkgroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListManagedWorkgroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListManagedWorkgroupsRequest, ListManagedWorkgroupsResponse>()
                            .withOperationName("ListManagedWorkgroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListManagedWorkgroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listManagedWorkgroupsRequest));
            CompletableFuture<ListManagedWorkgroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNamespacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNamespacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamespaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNamespacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNamespacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListNamespacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNamespacesRequest, ListNamespacesResponse>()
                            .withOperationName("ListNamespaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNamespacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNamespacesRequest));
            CompletableFuture<ListNamespacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return A Java Future containing the result of the ListRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecoveryPointsResponse> listRecoveryPoints(ListRecoveryPointsRequest listRecoveryPointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecoveryPointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecoveryPointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecoveryPointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListRecoveryPointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsRequest, ListRecoveryPointsResponse>()
                            .withOperationName("ListRecoveryPoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecoveryPointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecoveryPointsRequest));
            CompletableFuture<ListRecoveryPointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current reservation offerings in your account.
     * </p>
     *
     * @param listReservationOfferingsRequest
     * @return A Java Future containing the result of the ListReservationOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservationOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReservationOfferingsResponse> listReservationOfferings(
            ListReservationOfferingsRequest listReservationOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReservationOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReservationOfferingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReservationOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReservationOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReservationOfferingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListReservationOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReservationOfferingsRequest, ListReservationOfferingsResponse>()
                            .withOperationName("ListReservationOfferings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReservationOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReservationOfferingsRequest));
            CompletableFuture<ListReservationOfferingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of Reservation objects.
     * </p>
     *
     * @param listReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListReservations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReservations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReservationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReservationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListReservationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReservationsRequest, ListReservationsResponse>()
                            .withOperationName("ListReservations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReservationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReservationsRequest));
            CompletableFuture<ListReservationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.
     * </p>
     *
     * @param listScheduledActionsRequest
     * @return A Java Future containing the result of the ListScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListScheduledActionsResponse> listScheduledActions(
            ListScheduledActionsRequest listScheduledActionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listScheduledActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listScheduledActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListScheduledActions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListScheduledActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListScheduledActionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListScheduledActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListScheduledActionsRequest, ListScheduledActionsResponse>()
                            .withOperationName("ListScheduledActions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListScheduledActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listScheduledActionsRequest));
            CompletableFuture<ListScheduledActionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of snapshot copy configurations.
     * </p>
     *
     * @param listSnapshotCopyConfigurationsRequest
     * @return A Java Future containing the result of the ListSnapshotCopyConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshotCopyConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSnapshotCopyConfigurationsResponse> listSnapshotCopyConfigurations(
            ListSnapshotCopyConfigurationsRequest listSnapshotCopyConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSnapshotCopyConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSnapshotCopyConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSnapshotCopyConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSnapshotCopyConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSnapshotCopyConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSnapshotCopyConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSnapshotCopyConfigurationsRequest, ListSnapshotCopyConfigurationsResponse>()
                            .withOperationName("ListSnapshotCopyConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSnapshotCopyConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSnapshotCopyConfigurationsRequest));
            CompletableFuture<ListSnapshotCopyConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSnapshotsResponse> listSnapshots(ListSnapshotsRequest listSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSnapshotsRequest, ListSnapshotsResponse>()
                            .withOperationName("ListSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSnapshotsRequest));
            CompletableFuture<ListSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return A Java Future containing the result of the ListTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTableRestoreStatusResponse> listTableRestoreStatus(
            ListTableRestoreStatusRequest listTableRestoreStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTableRestoreStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTableRestoreStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableRestoreStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTableRestoreStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTableRestoreStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTableRestoreStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTableRestoreStatusRequest, ListTableRestoreStatusResponse>()
                            .withOperationName("ListTableRestoreStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTableRestoreStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTableRestoreStatusRequest));
            CompletableFuture<ListTableRestoreStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the Amazon Redshift Serverless versions.
     * </p>
     *
     * @param listTracksRequest
     * @return A Java Future containing the result of the ListTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTracks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTracksResponse> listTracks(ListTracksRequest listTracksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTracksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTracksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTracks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTracksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTracksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTracksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTracksRequest, ListTracksResponse>().withOperationName("ListTracks")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTracksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTracksRequest));
            CompletableFuture<ListTracksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return A Java Future containing the result of the ListUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsageLimitsResponse> listUsageLimits(ListUsageLimitsRequest listUsageLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsageLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsageLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsageLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsageLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUsageLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListUsageLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsageLimitsRequest, ListUsageLimitsResponse>()
                            .withOperationName("ListUsageLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsageLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUsageLimitsRequest));
            CompletableFuture<ListUsageLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return A Java Future containing the result of the ListWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkgroupsResponse> listWorkgroups(ListWorkgroupsRequest listWorkgroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkgroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkgroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkgroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkgroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkgroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListWorkgroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkgroupsRequest, ListWorkgroupsResponse>()
                            .withOperationName("ListWorkgroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkgroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkgroupsRequest));
            CompletableFuture<ListWorkgroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     * @return A Java Future containing the result of the RestoreFromRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreFromRecoveryPointResponse> restoreFromRecoveryPoint(
            RestoreFromRecoveryPointRequest restoreFromRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreFromRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreFromRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreFromRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreFromRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreFromRecoveryPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RestoreFromRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreFromRecoveryPointRequest, RestoreFromRecoveryPointResponse>()
                            .withOperationName("RestoreFromRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreFromRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreFromRecoveryPointRequest));
            CompletableFuture<RestoreFromRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreFromSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreFromSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RestoreFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreFromSnapshotRequest, RestoreFromSnapshotResponse>()
                            .withOperationName("RestoreFromSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreFromSnapshotRequest));
            CompletableFuture<RestoreFromSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation
     * to restore tables with interleaved sort keys.
     * </p>
     *
     * @param restoreTableFromRecoveryPointRequest
     * @return A Java Future containing the result of the RestoreTableFromRecoveryPoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromRecoveryPoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreTableFromRecoveryPointResponse> restoreTableFromRecoveryPoint(
            RestoreTableFromRecoveryPointRequest restoreTableFromRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreTableFromRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreTableFromRecoveryPointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreTableFromRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreTableFromRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreTableFromRecoveryPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RestoreTableFromRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreTableFromRecoveryPointRequest, RestoreTableFromRecoveryPointResponse>()
                            .withOperationName("RestoreTableFromRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreTableFromRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreTableFromRecoveryPointRequest));
            CompletableFuture<RestoreTableFromRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreTableFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreTableFromSnapshotResponse> restoreTableFromSnapshot(
            RestoreTableFromSnapshotRequest restoreTableFromSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreTableFromSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreTableFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreTableFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreTableFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreTableFromSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RestoreTableFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreTableFromSnapshotRequest, RestoreTableFromSnapshotResponse>()
                            .withOperationName("RestoreTableFromSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreTableFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreTableFromSnapshotRequest));
            CompletableFuture<RestoreTableFromSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless certificate associated with a custom domain.
     * </p>
     *
     * @param updateCustomDomainAssociationRequest
     * @return A Java Future containing the result of the UpdateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateCustomDomainAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCustomDomainAssociationResponse> updateCustomDomainAssociation(
            UpdateCustomDomainAssociationRequest updateCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomDomainAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCustomDomainAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCustomDomainAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomDomainAssociationRequest, UpdateCustomDomainAssociationResponse>()
                            .withOperationName("UpdateCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCustomDomainAssociationRequest));
            CompletableFuture<UpdateCustomDomainAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     *
     * @param updateEndpointAccessRequest
     * @return A Java Future containing the result of the UpdateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointAccessResponse> updateEndpointAccess(
            UpdateEndpointAccessRequest updateEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointAccessRequest, UpdateEndpointAccessResponse>()
                            .withOperationName("UpdateEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEndpointAccessRequest));
            CompletableFuture<UpdateEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the lakehouse configuration for a namespace. This operation allows you to manage Amazon Redshift
     * federated permissions and Amazon Web Services IAM Identity Center trusted identity propagation.
     * </p>
     *
     * @param updateLakehouseConfigurationRequest
     * @return A Java Future containing the result of the UpdateLakehouseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DryRunException This exception is thrown when the request was successful, but dry run was enabled so
     *         no action was taken.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateLakehouseConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateLakehouseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLakehouseConfigurationResponse> updateLakehouseConfiguration(
            UpdateLakehouseConfigurationRequest updateLakehouseConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLakehouseConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLakehouseConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLakehouseConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLakehouseConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLakehouseConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateLakehouseConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLakehouseConfigurationRequest, UpdateLakehouseConfigurationResponse>()
                            .withOperationName("UpdateLakehouseConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateLakehouseConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateLakehouseConfigurationRequest));
            CompletableFuture<UpdateLakehouseConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     *
     * @param updateNamespaceRequest
     * @return A Java Future containing the result of the UpdateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNamespaceResponse> updateNamespace(UpdateNamespaceRequest updateNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNamespaceRequest, UpdateNamespaceResponse>()
                            .withOperationName("UpdateNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNamespaceRequest));
            CompletableFuture<UpdateNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a scheduled action.
     * </p>
     *
     * @param updateScheduledActionRequest
     * @return A Java Future containing the result of the UpdateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateScheduledActionResponse> updateScheduledAction(
            UpdateScheduledActionRequest updateScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateScheduledAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateScheduledActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateScheduledActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateScheduledActionRequest, UpdateScheduledActionResponse>()
                            .withOperationName("UpdateScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateScheduledActionRequest));
            CompletableFuture<UpdateScheduledActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSnapshotRequest, UpdateSnapshotResponse>()
                            .withOperationName("UpdateSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSnapshotRequest));
            CompletableFuture<UpdateSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a snapshot copy configuration.
     * </p>
     *
     * @param updateSnapshotCopyConfigurationRequest
     * @return A Java Future containing the result of the UpdateSnapshotCopyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshotCopyConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshotCopyConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSnapshotCopyConfigurationResponse> updateSnapshotCopyConfiguration(
            UpdateSnapshotCopyConfigurationRequest updateSnapshotCopyConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSnapshotCopyConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateSnapshotCopyConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSnapshotCopyConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSnapshotCopyConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSnapshotCopyConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateSnapshotCopyConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSnapshotCopyConfigurationRequest, UpdateSnapshotCopyConfigurationResponse>()
                            .withOperationName("UpdateSnapshotCopyConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSnapshotCopyConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSnapshotCopyConfigurationRequest));
            CompletableFuture<UpdateSnapshotCopyConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     *
     * @param updateUsageLimitRequest
     * @return A Java Future containing the result of the UpdateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUsageLimitResponse> updateUsageLimit(UpdateUsageLimitRequest updateUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUsageLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsageLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUsageLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUsageLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUsageLimitRequest, UpdateUsageLimitResponse>()
                            .withOperationName("UpdateUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUsageLimitRequest));
            CompletableFuture<UpdateUsageLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     * <p>
     * VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
     * reaching or being reached from the internet through internet gateways and egress-only internet gateways. If a
     * workgroup is in an account with VPC BPA turned on, the following capabilities are blocked:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creating a public access workgroup
     * </p>
     * </li>
     * <li>
     * <p>
     * Modifying a private workgroup to public
     * </p>
     * </li>
     * <li>
     * <p>
     * Adding a subnet with VPC BPA turned on to the workgroup when the workgroup is public
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param updateWorkgroupRequest
     * @return A Java Future containing the result of the UpdateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkgroupResponse> updateWorkgroup(UpdateWorkgroupRequest updateWorkgroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkgroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkgroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkgroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkgroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkgroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "InvalidPaginationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPaginationException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "Ipv6CidrBlockNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundException")
                            .httpStatusCode(400).exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InsufficientCapacityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DryRunException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DryRunException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateWorkgroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkgroupRequest, UpdateWorkgroupResponse>()
                            .withOperationName("UpdateWorkgroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkgroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWorkgroupRequest));
            CompletableFuture<UpdateWorkgroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final RedshiftServerlessServiceClientConfiguration serviceClientConfiguration() {
        return new RedshiftServerlessServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RedshiftServerlessException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        RedshiftServerlessServiceClientConfigurationBuilder serviceConfigBuilder = new RedshiftServerlessServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
