/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLakehouseConfigurationResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<UpdateLakehouseConfigurationResponse.Builder, UpdateLakehouseConfigurationResponse> {
    private static final SdkField<String> CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("catalogArn").getter(getter(UpdateLakehouseConfigurationResponse::catalogArn))
            .setter(setter(Builder::catalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogArn").build()).build();

    private static final SdkField<String> LAKEHOUSE_IDC_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lakehouseIdcApplicationArn")
            .getter(getter(UpdateLakehouseConfigurationResponse::lakehouseIdcApplicationArn))
            .setter(setter(Builder::lakehouseIdcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseIdcApplicationArn").build())
            .build();

    private static final SdkField<String> LAKEHOUSE_REGISTRATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lakehouseRegistrationStatus")
            .getter(getter(UpdateLakehouseConfigurationResponse::lakehouseRegistrationStatus))
            .setter(setter(Builder::lakehouseRegistrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseRegistrationStatus")
                    .build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(UpdateLakehouseConfigurationResponse::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ARN_FIELD,
            LAKEHOUSE_IDC_APPLICATION_ARN_FIELD, LAKEHOUSE_REGISTRATION_STATUS_FIELD, NAMESPACE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogArn;

    private final String lakehouseIdcApplicationArn;

    private final String lakehouseRegistrationStatus;

    private final String namespaceName;

    private UpdateLakehouseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.catalogArn = builder.catalogArn;
        this.lakehouseIdcApplicationArn = builder.lakehouseIdcApplicationArn;
        this.lakehouseRegistrationStatus = builder.lakehouseRegistrationStatus;
        this.namespaceName = builder.namespaceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Glue Data Catalog associated with the lakehouse configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Glue Data Catalog associated with the lakehouse configuration.
     */
    public final String catalogArn() {
        return catalogArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web Services IAM
     * Identity Center trusted identity propagation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web
     *         Services IAM Identity Center trusted identity propagation.
     */
    public final String lakehouseIdcApplicationArn() {
        return lakehouseIdcApplicationArn;
    }

    /**
     * <p>
     * The current status of the lakehouse registration. Indicates whether the namespace is successfully registered with
     * Amazon Redshift federated permissions.
     * </p>
     * 
     * @return The current status of the lakehouse registration. Indicates whether the namespace is successfully
     *         registered with Amazon Redshift federated permissions.
     */
    public final String lakehouseRegistrationStatus() {
        return lakehouseRegistrationStatus;
    }

    /**
     * <p>
     * The name of the namespace.
     * </p>
     * 
     * @return The name of the namespace.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(lakehouseIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(lakehouseRegistrationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLakehouseConfigurationResponse)) {
            return false;
        }
        UpdateLakehouseConfigurationResponse other = (UpdateLakehouseConfigurationResponse) obj;
        return Objects.equals(catalogArn(), other.catalogArn())
                && Objects.equals(lakehouseIdcApplicationArn(), other.lakehouseIdcApplicationArn())
                && Objects.equals(lakehouseRegistrationStatus(), other.lakehouseRegistrationStatus())
                && Objects.equals(namespaceName(), other.namespaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLakehouseConfigurationResponse").add("CatalogArn", catalogArn())
                .add("LakehouseIdcApplicationArn", lakehouseIdcApplicationArn())
                .add("LakehouseRegistrationStatus", lakehouseRegistrationStatus()).add("NamespaceName", namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalogArn":
            return Optional.ofNullable(clazz.cast(catalogArn()));
        case "lakehouseIdcApplicationArn":
            return Optional.ofNullable(clazz.cast(lakehouseIdcApplicationArn()));
        case "lakehouseRegistrationStatus":
            return Optional.ofNullable(clazz.cast(lakehouseRegistrationStatus()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalogArn", CATALOG_ARN_FIELD);
        map.put("lakehouseIdcApplicationArn", LAKEHOUSE_IDC_APPLICATION_ARN_FIELD);
        map.put("lakehouseRegistrationStatus", LAKEHOUSE_REGISTRATION_STATUS_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLakehouseConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateLakehouseConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLakehouseConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Glue Data Catalog associated with the lakehouse configuration.
         * </p>
         * 
         * @param catalogArn
         *        The Amazon Resource Name (ARN) of the Glue Data Catalog associated with the lakehouse configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogArn(String catalogArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web Services
         * IAM Identity Center trusted identity propagation.
         * </p>
         * 
         * @param lakehouseIdcApplicationArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web
         *        Services IAM Identity Center trusted identity propagation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn);

        /**
         * <p>
         * The current status of the lakehouse registration. Indicates whether the namespace is successfully registered
         * with Amazon Redshift federated permissions.
         * </p>
         * 
         * @param lakehouseRegistrationStatus
         *        The current status of the lakehouse registration. Indicates whether the namespace is successfully
         *        registered with Amazon Redshift federated permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakehouseRegistrationStatus(String lakehouseRegistrationStatus);

        /**
         * <p>
         * The name of the namespace.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String catalogArn;

        private String lakehouseIdcApplicationArn;

        private String lakehouseRegistrationStatus;

        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLakehouseConfigurationResponse model) {
            super(model);
            catalogArn(model.catalogArn);
            lakehouseIdcApplicationArn(model.lakehouseIdcApplicationArn);
            lakehouseRegistrationStatus(model.lakehouseRegistrationStatus);
            namespaceName(model.namespaceName);
        }

        public final String getCatalogArn() {
            return catalogArn;
        }

        public final void setCatalogArn(String catalogArn) {
            this.catalogArn = catalogArn;
        }

        @Override
        public final Builder catalogArn(String catalogArn) {
            this.catalogArn = catalogArn;
            return this;
        }

        public final String getLakehouseIdcApplicationArn() {
            return lakehouseIdcApplicationArn;
        }

        public final void setLakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
        }

        @Override
        public final Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
            return this;
        }

        public final String getLakehouseRegistrationStatus() {
            return lakehouseRegistrationStatus;
        }

        public final void setLakehouseRegistrationStatus(String lakehouseRegistrationStatus) {
            this.lakehouseRegistrationStatus = lakehouseRegistrationStatus;
        }

        @Override
        public final Builder lakehouseRegistrationStatus(String lakehouseRegistrationStatus) {
            this.lakehouseRegistrationStatus = lakehouseRegistrationStatus;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public UpdateLakehouseConfigurationResponse build() {
            return new UpdateLakehouseConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
