/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReservationsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<ListReservationsResponse.Builder, ListReservationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReservationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Reservation>> RESERVATIONS_LIST_FIELD = SdkField
            .<List<Reservation>> builder(MarshallingType.LIST)
            .memberName("reservationsList")
            .getter(getter(ListReservationsResponse::reservationsList))
            .setter(setter(Builder::reservationsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Reservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVATIONS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Reservation> reservationsList;

    private ListReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservationsList = builder.reservationsList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items.
     * </p>
     * 
     * @return The token to use when requesting the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservationsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReservationsList() {
        return reservationsList != null && !(reservationsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The serverless reservations returned by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservationsList} method.
     * </p>
     * 
     * @return The serverless reservations returned by the request.
     */
    public final List<Reservation> reservationsList() {
        return reservationsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservationsList() ? reservationsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationsResponse)) {
            return false;
        }
        ListReservationsResponse other = (ListReservationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReservationsList() == other.hasReservationsList()
                && Objects.equals(reservationsList(), other.reservationsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReservationsResponse").add("NextToken", nextToken())
                .add("ReservationsList", hasReservationsList() ? reservationsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "reservationsList":
            return Optional.ofNullable(clazz.cast(reservationsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("reservationsList", RESERVATIONS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReservationsResponse, T> g) {
        return obj -> g.apply((ListReservationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReservationsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The serverless reservations returned by the request.
         * </p>
         * 
         * @param reservationsList
         *        The serverless reservations returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationsList(Collection<Reservation> reservationsList);

        /**
         * <p>
         * The serverless reservations returned by the request.
         * </p>
         * 
         * @param reservationsList
         *        The serverless reservations returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationsList(Reservation... reservationsList);

        /**
         * <p>
         * The serverless reservations returned by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Reservation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Reservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Reservation.Builder#build()} is called
         * immediately and its result is passed to {@link #reservationsList(List<Reservation>)}.
         * 
         * @param reservationsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.Reservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationsList(java.util.Collection<Reservation>)
         */
        Builder reservationsList(Consumer<Reservation.Builder>... reservationsList);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Reservation> reservationsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReservationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservationsList(model.reservationsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Reservation.Builder> getReservationsList() {
            List<Reservation.Builder> result = ReservationsListCopier.copyToBuilder(this.reservationsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservationsList(Collection<Reservation.BuilderImpl> reservationsList) {
            this.reservationsList = ReservationsListCopier.copyFromBuilder(reservationsList);
        }

        @Override
        public final Builder reservationsList(Collection<Reservation> reservationsList) {
            this.reservationsList = ReservationsListCopier.copy(reservationsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservationsList(Reservation... reservationsList) {
            reservationsList(Arrays.asList(reservationsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservationsList(Consumer<Reservation.Builder>... reservationsList) {
            reservationsList(Stream.of(reservationsList).map(c -> Reservation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReservationsResponse build() {
            return new ListReservationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
