/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.Workgroup;

public class ListWorkgroupsPublisher
implements SdkPublisher<ListWorkgroupsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListWorkgroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkgroupsPublisher(RedshiftServerlessAsyncClient client, ListWorkgroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkgroupsPublisher(RedshiftServerlessAsyncClient client, ListWorkgroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkgroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkgroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Workgroup> workgroups() {
        Function<ListWorkgroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workgroups() != null) {
                return response.workgroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkgroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkgroupsResponseFetcher
    implements AsyncPageFetcher<ListWorkgroupsResponse> {
        private ListWorkgroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkgroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkgroupsResponse> nextPage(ListWorkgroupsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkgroupsPublisher.this.client.listWorkgroups(ListWorkgroupsPublisher.this.firstRequest);
            }
            return ListWorkgroupsPublisher.this.client.listWorkgroups((ListWorkgroupsRequest)((Object)ListWorkgroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

