/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreFromSnapshotRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, RestoreFromSnapshotRequest> {
    private static final SdkField<String> ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminPasswordSecretKmsKeyId").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::adminPasswordSecretKmsKeyId)).setter(RestoreFromSnapshotRequest.setter(Builder::adminPasswordSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretKmsKeyId").build()}).build();
    private static final SdkField<Boolean> MANAGE_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("manageAdminPassword").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::manageAdminPassword)).setter(RestoreFromSnapshotRequest.setter(Builder::manageAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAdminPassword").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::namespaceName)).setter(RestoreFromSnapshotRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::ownerAccount)).setter(RestoreFromSnapshotRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotArn").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::snapshotArn)).setter(RestoreFromSnapshotRequest.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::snapshotName)).setter(RestoreFromSnapshotRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(RestoreFromSnapshotRequest.getter(RestoreFromSnapshotRequest::workgroupName)).setter(RestoreFromSnapshotRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD, MANAGE_ADMIN_PASSWORD_FIELD, NAMESPACE_NAME_FIELD, OWNER_ACCOUNT_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_NAME_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreFromSnapshotRequest.memberNameToFieldInitializer();
    private final String adminPasswordSecretKmsKeyId;
    private final Boolean manageAdminPassword;
    private final String namespaceName;
    private final String ownerAccount;
    private final String snapshotArn;
    private final String snapshotName;
    private final String workgroupName;

    private RestoreFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
        this.manageAdminPassword = builder.manageAdminPassword;
        this.namespaceName = builder.namespaceName;
        this.ownerAccount = builder.ownerAccount;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotName = builder.snapshotName;
        this.workgroupName = builder.workgroupName;
    }

    public final String adminPasswordSecretKmsKeyId() {
        return this.adminPasswordSecretKmsKeyId;
    }

    public final Boolean manageAdminPassword() {
        return this.manageAdminPassword;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromSnapshotRequest)) {
            return false;
        }
        RestoreFromSnapshotRequest other = (RestoreFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.adminPasswordSecretKmsKeyId(), other.adminPasswordSecretKmsKeyId()) && Objects.equals(this.manageAdminPassword(), other.manageAdminPassword()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreFromSnapshotRequest").add("AdminPasswordSecretKmsKeyId", (Object)this.adminPasswordSecretKmsKeyId()).add("ManageAdminPassword", (Object)this.manageAdminPassword()).add("NamespaceName", (Object)this.namespaceName()).add("OwnerAccount", (Object)this.ownerAccount()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotName", (Object)this.snapshotName()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminPasswordSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.adminPasswordSecretKmsKeyId()));
            }
            case "manageAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.manageAdminPassword()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "snapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adminPasswordSecretKmsKeyId", ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD);
        map.put("manageAdminPassword", MANAGE_ADMIN_PASSWORD_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("snapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("snapshotName", SNAPSHOT_NAME_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String adminPasswordSecretKmsKeyId;
        private Boolean manageAdminPassword;
        private String namespaceName;
        private String ownerAccount;
        private String snapshotArn;
        private String snapshotName;
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromSnapshotRequest model) {
            super(model);
            this.adminPasswordSecretKmsKeyId(model.adminPasswordSecretKmsKeyId);
            this.manageAdminPassword(model.manageAdminPassword);
            this.namespaceName(model.namespaceName);
            this.ownerAccount(model.ownerAccount);
            this.snapshotArn(model.snapshotArn);
            this.snapshotName(model.snapshotName);
            this.workgroupName(model.workgroupName);
        }

        public final String getAdminPasswordSecretKmsKeyId() {
            return this.adminPasswordSecretKmsKeyId;
        }

        public final void setAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
            return this;
        }

        public final Boolean getManageAdminPassword() {
            return this.manageAdminPassword;
        }

        public final void setManageAdminPassword(Boolean manageAdminPassword) {
            this.manageAdminPassword = manageAdminPassword;
        }

        @Override
        public final Builder manageAdminPassword(Boolean manageAdminPassword) {
            this.manageAdminPassword = manageAdminPassword;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromSnapshotRequest build() {
            return new RestoreFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreFromSnapshotRequest> {
        public Builder adminPasswordSecretKmsKeyId(String var1);

        public Builder manageAdminPassword(Boolean var1);

        public Builder namespaceName(String var1);

        public Builder ownerAccount(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotName(String var1);

        public Builder workgroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

