/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering;
import software.amazon.awssdk.services.redshiftserverless.model.ReservationOfferingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReservationOfferingsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListReservationOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReservationOfferingsResponse.getter(ListReservationOfferingsResponse::nextToken)).setter(ListReservationOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ReservationOffering>> RESERVATION_OFFERINGS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reservationOfferingsList").getter(ListReservationOfferingsResponse.getter(ListReservationOfferingsResponse::reservationOfferingsList)).setter(ListReservationOfferingsResponse.setter(Builder::reservationOfferingsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationOfferingsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservationOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVATION_OFFERINGS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReservationOfferingsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ReservationOffering> reservationOfferingsList;

    private ListReservationOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservationOfferingsList = builder.reservationOfferingsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservationOfferingsList() {
        return this.reservationOfferingsList != null && !(this.reservationOfferingsList instanceof SdkAutoConstructList);
    }

    public final List<ReservationOffering> reservationOfferingsList() {
        return this.reservationOfferingsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservationOfferingsList() ? this.reservationOfferingsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationOfferingsResponse)) {
            return false;
        }
        ListReservationOfferingsResponse other = (ListReservationOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservationOfferingsList() == other.hasReservationOfferingsList() && Objects.equals(this.reservationOfferingsList(), other.reservationOfferingsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListReservationOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("ReservationOfferingsList", this.hasReservationOfferingsList() ? this.reservationOfferingsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "reservationOfferingsList": {
                return Optional.ofNullable(clazz.cast(this.reservationOfferingsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("reservationOfferingsList", RESERVATION_OFFERINGS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReservationOfferingsResponse, T> g) {
        return obj -> g.apply((ListReservationOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservationOffering> reservationOfferingsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReservationOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservationOfferingsList(model.reservationOfferingsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservationOffering.Builder> getReservationOfferingsList() {
            List<ReservationOffering.Builder> result = ReservationOfferingsListCopier.copyToBuilder(this.reservationOfferingsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservationOfferingsList(Collection<ReservationOffering.BuilderImpl> reservationOfferingsList) {
            this.reservationOfferingsList = ReservationOfferingsListCopier.copyFromBuilder(reservationOfferingsList);
        }

        @Override
        public final Builder reservationOfferingsList(Collection<ReservationOffering> reservationOfferingsList) {
            this.reservationOfferingsList = ReservationOfferingsListCopier.copy(reservationOfferingsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservationOfferingsList(ReservationOffering ... reservationOfferingsList) {
            this.reservationOfferingsList(Arrays.asList(reservationOfferingsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservationOfferingsList(Consumer<ReservationOffering.Builder> ... reservationOfferingsList) {
            this.reservationOfferingsList(Stream.of(reservationOfferingsList).map(c -> (ReservationOffering)((ReservationOffering.Builder)ReservationOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReservationOfferingsResponse build() {
            return new ListReservationOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReservationOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder reservationOfferingsList(Collection<ReservationOffering> var1);

        public Builder reservationOfferingsList(ReservationOffering ... var1);

        public Builder reservationOfferingsList(Consumer<ReservationOffering.Builder> ... var1);
    }
}

