/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.LogExport;
import software.amazon.awssdk.services.redshiftserverless.model.LogExportListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNamespaceRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, UpdateNamespaceRequest> {
    private static final SdkField<String> ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminPasswordSecretKmsKeyId").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::adminPasswordSecretKmsKeyId)).setter(UpdateNamespaceRequest.setter(Builder::adminPasswordSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretKmsKeyId").build()}).build();
    private static final SdkField<String> ADMIN_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUserPassword").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::adminUserPassword)).setter(UpdateNamespaceRequest.setter(Builder::adminUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserPassword").build()}).build();
    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUsername").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::adminUsername)).setter(UpdateNamespaceRequest.setter(Builder::adminUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()}).build();
    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultIamRoleArn").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::defaultIamRoleArn)).setter(UpdateNamespaceRequest.setter(Builder::defaultIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultIamRoleArn").build()}).build();
    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("iamRoles").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::iamRoles)).setter(UpdateNamespaceRequest.setter(Builder::iamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::kmsKeyId)).setter(UpdateNamespaceRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logExports").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::logExportsAsStrings)).setter(UpdateNamespaceRequest.setter(Builder::logExportsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MANAGE_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("manageAdminPassword").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::manageAdminPassword)).setter(UpdateNamespaceRequest.setter(Builder::manageAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAdminPassword").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(UpdateNamespaceRequest.getter(UpdateNamespaceRequest::namespaceName)).setter(UpdateNamespaceRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD, ADMIN_USER_PASSWORD_FIELD, ADMIN_USERNAME_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD, IAM_ROLES_FIELD, KMS_KEY_ID_FIELD, LOG_EXPORTS_FIELD, MANAGE_ADMIN_PASSWORD_FIELD, NAMESPACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateNamespaceRequest.memberNameToFieldInitializer();
    private final String adminPasswordSecretKmsKeyId;
    private final String adminUserPassword;
    private final String adminUsername;
    private final String defaultIamRoleArn;
    private final List<String> iamRoles;
    private final String kmsKeyId;
    private final List<String> logExports;
    private final Boolean manageAdminPassword;
    private final String namespaceName;

    private UpdateNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
        this.adminUserPassword = builder.adminUserPassword;
        this.adminUsername = builder.adminUsername;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.iamRoles = builder.iamRoles;
        this.kmsKeyId = builder.kmsKeyId;
        this.logExports = builder.logExports;
        this.manageAdminPassword = builder.manageAdminPassword;
        this.namespaceName = builder.namespaceName;
    }

    public final String adminPasswordSecretKmsKeyId() {
        return this.adminPasswordSecretKmsKeyId;
    }

    public final String adminUserPassword() {
        return this.adminUserPassword;
    }

    public final String adminUsername() {
        return this.adminUsername;
    }

    public final String defaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    public final boolean hasIamRoles() {
        return this.iamRoles != null && !(this.iamRoles instanceof SdkAutoConstructList);
    }

    public final List<String> iamRoles() {
        return this.iamRoles;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final List<LogExport> logExports() {
        return LogExportListCopier.copyStringToEnum(this.logExports);
    }

    public final boolean hasLogExports() {
        return this.logExports != null && !(this.logExports instanceof SdkAutoConstructList);
    }

    public final List<String> logExportsAsStrings() {
        return this.logExports;
    }

    public final Boolean manageAdminPassword() {
        return this.manageAdminPassword;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamRoles() ? this.iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogExports() ? this.logExportsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNamespaceRequest)) {
            return false;
        }
        UpdateNamespaceRequest other = (UpdateNamespaceRequest)((Object)obj);
        return Objects.equals(this.adminPasswordSecretKmsKeyId(), other.adminPasswordSecretKmsKeyId()) && Objects.equals(this.adminUserPassword(), other.adminUserPassword()) && Objects.equals(this.adminUsername(), other.adminUsername()) && Objects.equals(this.defaultIamRoleArn(), other.defaultIamRoleArn()) && this.hasIamRoles() == other.hasIamRoles() && Objects.equals(this.iamRoles(), other.iamRoles()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasLogExports() == other.hasLogExports() && Objects.equals(this.logExportsAsStrings(), other.logExportsAsStrings()) && Objects.equals(this.manageAdminPassword(), other.manageAdminPassword()) && Objects.equals(this.namespaceName(), other.namespaceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNamespaceRequest").add("AdminPasswordSecretKmsKeyId", (Object)this.adminPasswordSecretKmsKeyId()).add("AdminUserPassword", (Object)(this.adminUserPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("AdminUsername", (Object)(this.adminUsername() == null ? null : "*** Sensitive Data Redacted ***")).add("DefaultIamRoleArn", (Object)this.defaultIamRoleArn()).add("IamRoles", this.hasIamRoles() ? this.iamRoles() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("LogExports", this.hasLogExports() ? this.logExportsAsStrings() : null).add("ManageAdminPassword", (Object)this.manageAdminPassword()).add("NamespaceName", (Object)this.namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminPasswordSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.adminPasswordSecretKmsKeyId()));
            }
            case "adminUserPassword": {
                return Optional.ofNullable(clazz.cast(this.adminUserPassword()));
            }
            case "adminUsername": {
                return Optional.ofNullable(clazz.cast(this.adminUsername()));
            }
            case "defaultIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.defaultIamRoleArn()));
            }
            case "iamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "logExports": {
                return Optional.ofNullable(clazz.cast(this.logExportsAsStrings()));
            }
            case "manageAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.manageAdminPassword()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adminPasswordSecretKmsKeyId", ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD);
        map.put("adminUserPassword", ADMIN_USER_PASSWORD_FIELD);
        map.put("adminUsername", ADMIN_USERNAME_FIELD);
        map.put("defaultIamRoleArn", DEFAULT_IAM_ROLE_ARN_FIELD);
        map.put("iamRoles", IAM_ROLES_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("logExports", LOG_EXPORTS_FIELD);
        map.put("manageAdminPassword", MANAGE_ADMIN_PASSWORD_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNamespaceRequest, T> g) {
        return obj -> g.apply((UpdateNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String adminPasswordSecretKmsKeyId;
        private String adminUserPassword;
        private String adminUsername;
        private String defaultIamRoleArn;
        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();
        private Boolean manageAdminPassword;
        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNamespaceRequest model) {
            super(model);
            this.adminPasswordSecretKmsKeyId(model.adminPasswordSecretKmsKeyId);
            this.adminUserPassword(model.adminUserPassword);
            this.adminUsername(model.adminUsername);
            this.defaultIamRoleArn(model.defaultIamRoleArn);
            this.iamRoles(model.iamRoles);
            this.kmsKeyId(model.kmsKeyId);
            this.logExportsWithStrings(model.logExports);
            this.manageAdminPassword(model.manageAdminPassword);
            this.namespaceName(model.namespaceName);
        }

        public final String getAdminPasswordSecretKmsKeyId() {
            return this.adminPasswordSecretKmsKeyId;
        }

        public final void setAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
            return this;
        }

        public final String getAdminUserPassword() {
            return this.adminUserPassword;
        }

        public final void setAdminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
        }

        @Override
        public final Builder adminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        public final String getAdminUsername() {
            return this.adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (this.iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getLogExports() {
            if (this.logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
        }

        @Override
        public final Builder logExportsWithStrings(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExportsWithStrings(String ... logExports) {
            this.logExportsWithStrings(Arrays.asList(logExports));
            return this;
        }

        @Override
        public final Builder logExports(Collection<LogExport> logExports) {
            this.logExports = LogExportListCopier.copyEnumToString(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(LogExport ... logExports) {
            this.logExports(Arrays.asList(logExports));
            return this;
        }

        public final Boolean getManageAdminPassword() {
            return this.manageAdminPassword;
        }

        public final void setManageAdminPassword(Boolean manageAdminPassword) {
            this.manageAdminPassword = manageAdminPassword;
        }

        @Override
        public final Builder manageAdminPassword(Boolean manageAdminPassword) {
            this.manageAdminPassword = manageAdminPassword;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNamespaceRequest build() {
            return new UpdateNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNamespaceRequest> {
        public Builder adminPasswordSecretKmsKeyId(String var1);

        public Builder adminUserPassword(String var1);

        public Builder adminUsername(String var1);

        public Builder defaultIamRoleArn(String var1);

        public Builder iamRoles(Collection<String> var1);

        public Builder iamRoles(String ... var1);

        public Builder kmsKeyId(String var1);

        public Builder logExportsWithStrings(Collection<String> var1);

        public Builder logExportsWithStrings(String ... var1);

        public Builder logExports(Collection<LogExport> var1);

        public Builder logExports(LogExport ... var1);

        public Builder manageAdminPassword(Boolean var1);

        public Builder namespaceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

