/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.Tag;
import software.amazon.awssdk.services.redshiftserverless.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConvertRecoveryPointToSnapshotRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, ConvertRecoveryPointToSnapshotRequest> {
    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryPointId").getter(ConvertRecoveryPointToSnapshotRequest.getter(ConvertRecoveryPointToSnapshotRequest::recoveryPointId)).setter(ConvertRecoveryPointToSnapshotRequest.setter(Builder::recoveryPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionPeriod").getter(ConvertRecoveryPointToSnapshotRequest.getter(ConvertRecoveryPointToSnapshotRequest::retentionPeriod)).setter(ConvertRecoveryPointToSnapshotRequest.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(ConvertRecoveryPointToSnapshotRequest.getter(ConvertRecoveryPointToSnapshotRequest::snapshotName)).setter(ConvertRecoveryPointToSnapshotRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ConvertRecoveryPointToSnapshotRequest.getter(ConvertRecoveryPointToSnapshotRequest::tags)).setter(ConvertRecoveryPointToSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ID_FIELD, RETENTION_PERIOD_FIELD, SNAPSHOT_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("recoveryPointId", RECOVERY_POINT_ID_FIELD);
            this.put("retentionPeriod", RETENTION_PERIOD_FIELD);
            this.put("snapshotName", SNAPSHOT_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String recoveryPointId;
    private final Integer retentionPeriod;
    private final String snapshotName;
    private final List<Tag> tags;

    private ConvertRecoveryPointToSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.recoveryPointId = builder.recoveryPointId;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotName = builder.snapshotName;
        this.tags = builder.tags;
    }

    public final String recoveryPointId() {
        return this.recoveryPointId;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConvertRecoveryPointToSnapshotRequest)) {
            return false;
        }
        ConvertRecoveryPointToSnapshotRequest other = (ConvertRecoveryPointToSnapshotRequest)((Object)obj);
        return Objects.equals(this.recoveryPointId(), other.recoveryPointId()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.snapshotName(), other.snapshotName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ConvertRecoveryPointToSnapshotRequest").add("RecoveryPointId", (Object)this.recoveryPointId()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("SnapshotName", (Object)this.snapshotName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recoveryPointId": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointId()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConvertRecoveryPointToSnapshotRequest, T> g) {
        return obj -> g.apply((ConvertRecoveryPointToSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String recoveryPointId;
        private Integer retentionPeriod;
        private String snapshotName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConvertRecoveryPointToSnapshotRequest model) {
            super(model);
            this.recoveryPointId(model.recoveryPointId);
            this.retentionPeriod(model.retentionPeriod);
            this.snapshotName(model.snapshotName);
            this.tags(model.tags);
        }

        public final String getRecoveryPointId() {
            return this.recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConvertRecoveryPointToSnapshotRequest build() {
            return new ConvertRecoveryPointToSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConvertRecoveryPointToSnapshotRequest> {
        public Builder recoveryPointId(String var1);

        public Builder retentionPeriod(Integer var1);

        public Builder snapshotName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

