/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotCopyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotCopyConfiguration> {
    private static final SdkField<String> DESTINATION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationKmsKeyId").getter(SnapshotCopyConfiguration.getter(SnapshotCopyConfiguration::destinationKmsKeyId)).setter(SnapshotCopyConfiguration.setter(Builder::destinationKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationKmsKeyId").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationRegion").getter(SnapshotCopyConfiguration.getter(SnapshotCopyConfiguration::destinationRegion)).setter(SnapshotCopyConfiguration.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(SnapshotCopyConfiguration.getter(SnapshotCopyConfiguration::namespaceName)).setter(SnapshotCopyConfiguration.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> SNAPSHOT_COPY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotCopyConfigurationArn").getter(SnapshotCopyConfiguration.getter(SnapshotCopyConfiguration::snapshotCopyConfigurationArn)).setter(SnapshotCopyConfiguration.setter(Builder::snapshotCopyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfigurationArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_COPY_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotCopyConfigurationId").getter(SnapshotCopyConfiguration.getter(SnapshotCopyConfiguration::snapshotCopyConfigurationId)).setter(SnapshotCopyConfiguration.setter(Builder::snapshotCopyConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfigurationId").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("snapshotRetentionPeriod").getter(SnapshotCopyConfiguration.getter(SnapshotCopyConfiguration::snapshotRetentionPeriod)).setter(SnapshotCopyConfiguration.setter(Builder::snapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_KMS_KEY_ID_FIELD, DESTINATION_REGION_FIELD, NAMESPACE_NAME_FIELD, SNAPSHOT_COPY_CONFIGURATION_ARN_FIELD, SNAPSHOT_COPY_CONFIGURATION_ID_FIELD, SNAPSHOT_RETENTION_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationKmsKeyId;
    private final String destinationRegion;
    private final String namespaceName;
    private final String snapshotCopyConfigurationArn;
    private final String snapshotCopyConfigurationId;
    private final Integer snapshotRetentionPeriod;

    private SnapshotCopyConfiguration(BuilderImpl builder) {
        this.destinationKmsKeyId = builder.destinationKmsKeyId;
        this.destinationRegion = builder.destinationRegion;
        this.namespaceName = builder.namespaceName;
        this.snapshotCopyConfigurationArn = builder.snapshotCopyConfigurationArn;
        this.snapshotCopyConfigurationId = builder.snapshotCopyConfigurationId;
        this.snapshotRetentionPeriod = builder.snapshotRetentionPeriod;
    }

    public final String destinationKmsKeyId() {
        return this.destinationKmsKeyId;
    }

    public final String destinationRegion() {
        return this.destinationRegion;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String snapshotCopyConfigurationArn() {
        return this.snapshotCopyConfigurationArn;
    }

    public final String snapshotCopyConfigurationId() {
        return this.snapshotCopyConfigurationId;
    }

    public final Integer snapshotRetentionPeriod() {
        return this.snapshotRetentionPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotCopyConfiguration)) {
            return false;
        }
        SnapshotCopyConfiguration other = (SnapshotCopyConfiguration)obj;
        return Objects.equals(this.destinationKmsKeyId(), other.destinationKmsKeyId()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.snapshotCopyConfigurationArn(), other.snapshotCopyConfigurationArn()) && Objects.equals(this.snapshotCopyConfigurationId(), other.snapshotCopyConfigurationId()) && Objects.equals(this.snapshotRetentionPeriod(), other.snapshotRetentionPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotCopyConfiguration").add("DestinationKmsKeyId", (Object)this.destinationKmsKeyId()).add("DestinationRegion", (Object)this.destinationRegion()).add("NamespaceName", (Object)this.namespaceName()).add("SnapshotCopyConfigurationArn", (Object)this.snapshotCopyConfigurationArn()).add("SnapshotCopyConfigurationId", (Object)this.snapshotCopyConfigurationId()).add("SnapshotRetentionPeriod", (Object)this.snapshotRetentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.destinationKmsKeyId()));
            }
            case "destinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "snapshotCopyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyConfigurationArn()));
            }
            case "snapshotCopyConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyConfigurationId()));
            }
            case "snapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotCopyConfiguration, T> g) {
        return obj -> g.apply((SnapshotCopyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationKmsKeyId;
        private String destinationRegion;
        private String namespaceName;
        private String snapshotCopyConfigurationArn;
        private String snapshotCopyConfigurationId;
        private Integer snapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotCopyConfiguration model) {
            this.destinationKmsKeyId(model.destinationKmsKeyId);
            this.destinationRegion(model.destinationRegion);
            this.namespaceName(model.namespaceName);
            this.snapshotCopyConfigurationArn(model.snapshotCopyConfigurationArn);
            this.snapshotCopyConfigurationId(model.snapshotCopyConfigurationId);
            this.snapshotRetentionPeriod(model.snapshotRetentionPeriod);
        }

        public final String getDestinationKmsKeyId() {
            return this.destinationKmsKeyId;
        }

        public final void setDestinationKmsKeyId(String destinationKmsKeyId) {
            this.destinationKmsKeyId = destinationKmsKeyId;
        }

        @Override
        public final Builder destinationKmsKeyId(String destinationKmsKeyId) {
            this.destinationKmsKeyId = destinationKmsKeyId;
            return this;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getSnapshotCopyConfigurationArn() {
            return this.snapshotCopyConfigurationArn;
        }

        public final void setSnapshotCopyConfigurationArn(String snapshotCopyConfigurationArn) {
            this.snapshotCopyConfigurationArn = snapshotCopyConfigurationArn;
        }

        @Override
        public final Builder snapshotCopyConfigurationArn(String snapshotCopyConfigurationArn) {
            this.snapshotCopyConfigurationArn = snapshotCopyConfigurationArn;
            return this;
        }

        public final String getSnapshotCopyConfigurationId() {
            return this.snapshotCopyConfigurationId;
        }

        public final void setSnapshotCopyConfigurationId(String snapshotCopyConfigurationId) {
            this.snapshotCopyConfigurationId = snapshotCopyConfigurationId;
        }

        @Override
        public final Builder snapshotCopyConfigurationId(String snapshotCopyConfigurationId) {
            this.snapshotCopyConfigurationId = snapshotCopyConfigurationId;
            return this;
        }

        public final Integer getSnapshotRetentionPeriod() {
            return this.snapshotRetentionPeriod;
        }

        public final void setSnapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
        }

        @Override
        public final Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
            return this;
        }

        public SnapshotCopyConfiguration build() {
            return new SnapshotCopyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotCopyConfiguration> {
        public Builder destinationKmsKeyId(String var1);

        public Builder destinationRegion(String var1);

        public Builder namespaceName(String var1);

        public Builder snapshotCopyConfigurationArn(String var1);

        public Builder snapshotCopyConfigurationId(String var1);

        public Builder snapshotRetentionPeriod(Integer var1);
    }
}

