/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCredentialsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<GetCredentialsResponse.Builder, GetCredentialsResponse> {
    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbPassword").getter(getter(GetCredentialsResponse::dbPassword)).setter(setter(Builder::dbPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPassword").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dbUser")
            .getter(getter(GetCredentialsResponse::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbUser").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiration").getter(getter(GetCredentialsResponse::expiration)).setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()).build();

    private static final SdkField<Instant> NEXT_REFRESH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("nextRefreshTime").getter(getter(GetCredentialsResponse::nextRefreshTime))
            .setter(setter(Builder::nextRefreshTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextRefreshTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PASSWORD_FIELD,
            DB_USER_FIELD, EXPIRATION_FIELD, NEXT_REFRESH_TIME_FIELD));

    private final String dbPassword;

    private final String dbUser;

    private final Instant expiration;

    private final Instant nextRefreshTime;

    private GetCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.dbPassword = builder.dbPassword;
        this.dbUser = builder.dbUser;
        this.expiration = builder.expiration;
        this.nextRefreshTime = builder.nextRefreshTime;
    }

    /**
     * <p>
     * A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database
     * <code>DbName</code>.
     * </p>
     * 
     * @return A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the
     *         database <code>DbName</code>.
     */
    public final String dbPassword() {
        return dbPassword;
    }

    /**
     * <p>
     * A database user name that is authorized to log on to the database <code>DbName</code> using the password
     * <code>DbPassword</code>. If the specified <code>DbUser</code> exists in the database, the new user name has the
     * same database privileges as the the user named in <code>DbUser</code>. By default, the user is added to PUBLIC.
     * </p>
     * 
     * @return A database user name that is authorized to log on to the database <code>DbName</code> using the password
     *         <code>DbPassword</code>. If the specified <code>DbUser</code> exists in the database, the new user name
     *         has the same database privileges as the the user named in <code>DbUser</code>. By default, the user is
     *         added to PUBLIC.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The date and time the password in <code>DbPassword</code> expires.
     * </p>
     * 
     * @return The date and time the password in <code>DbPassword</code> expires.
     */
    public final Instant expiration() {
        return expiration;
    }

    /**
     * <p>
     * The date and time of when the <code>DbUser</code> and <code>DbPassword</code> authorization refreshes.
     * </p>
     * 
     * @return The date and time of when the <code>DbUser</code> and <code>DbPassword</code> authorization refreshes.
     */
    public final Instant nextRefreshTime() {
        return nextRefreshTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(nextRefreshTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsResponse)) {
            return false;
        }
        GetCredentialsResponse other = (GetCredentialsResponse) obj;
        return Objects.equals(dbPassword(), other.dbPassword()) && Objects.equals(dbUser(), other.dbUser())
                && Objects.equals(expiration(), other.expiration()) && Objects.equals(nextRefreshTime(), other.nextRefreshTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCredentialsResponse")
                .add("DbPassword", dbPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DbUser", dbUser() == null ? null : "*** Sensitive Data Redacted ***").add("Expiration", expiration())
                .add("NextRefreshTime", nextRefreshTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbPassword":
            return Optional.ofNullable(clazz.cast(dbPassword()));
        case "dbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "nextRefreshTime":
            return Optional.ofNullable(clazz.cast(nextRefreshTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialsResponse, T> g) {
        return obj -> g.apply((GetCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCredentialsResponse> {
        /**
         * <p>
         * A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database
         * <code>DbName</code>.
         * </p>
         * 
         * @param dbPassword
         *        A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the
         *        database <code>DbName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        /**
         * <p>
         * A database user name that is authorized to log on to the database <code>DbName</code> using the password
         * <code>DbPassword</code>. If the specified <code>DbUser</code> exists in the database, the new user name has
         * the same database privileges as the the user named in <code>DbUser</code>. By default, the user is added to
         * PUBLIC.
         * </p>
         * 
         * @param dbUser
         *        A database user name that is authorized to log on to the database <code>DbName</code> using the
         *        password <code>DbPassword</code>. If the specified <code>DbUser</code> exists in the database, the new
         *        user name has the same database privileges as the the user named in <code>DbUser</code>. By default,
         *        the user is added to PUBLIC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The date and time the password in <code>DbPassword</code> expires.
         * </p>
         * 
         * @param expiration
         *        The date and time the password in <code>DbPassword</code> expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);

        /**
         * <p>
         * The date and time of when the <code>DbUser</code> and <code>DbPassword</code> authorization refreshes.
         * </p>
         * 
         * @param nextRefreshTime
         *        The date and time of when the <code>DbUser</code> and <code>DbPassword</code> authorization refreshes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRefreshTime(Instant nextRefreshTime);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String dbPassword;

        private String dbUser;

        private Instant expiration;

        private Instant nextRefreshTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsResponse model) {
            super(model);
            dbPassword(model.dbPassword);
            dbUser(model.dbUser);
            expiration(model.expiration);
            nextRefreshTime(model.nextRefreshTime);
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final Instant getNextRefreshTime() {
            return nextRefreshTime;
        }

        public final void setNextRefreshTime(Instant nextRefreshTime) {
            this.nextRefreshTime = nextRefreshTime;
        }

        @Override
        public final Builder nextRefreshTime(Instant nextRefreshTime) {
            this.nextRefreshTime = nextRefreshTime;
            return this;
        }

        @Override
        public GetCredentialsResponse build() {
            return new GetCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
