/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.Namespace;

public class ListNamespacesPublisher
implements SdkPublisher<ListNamespacesResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNamespacesPublisher(RedshiftServerlessAsyncClient client, ListNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNamespacesPublisher(RedshiftServerlessAsyncClient client, ListNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Namespace> namespaces() {
        Function<ListNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.namespaces() != null) {
                return response.namespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNamespacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNamespacesResponseFetcher
    implements AsyncPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNamespacesResponse> nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesPublisher.this.client.listNamespaces(ListNamespacesPublisher.this.firstRequest);
            }
            return ListNamespacesPublisher.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

