/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimit;

public class ListUsageLimitsPublisher
implements SdkPublisher<ListUsageLimitsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListUsageLimitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUsageLimitsPublisher(RedshiftServerlessAsyncClient client, ListUsageLimitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUsageLimitsPublisher(RedshiftServerlessAsyncClient client, ListUsageLimitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUsageLimitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUsageLimitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsageLimit> usageLimits() {
        Function<ListUsageLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.usageLimits() != null) {
                return response.usageLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUsageLimitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUsageLimitsResponseFetcher
    implements AsyncPageFetcher<ListUsageLimitsResponse> {
        private ListUsageLimitsResponseFetcher() {
        }

        public boolean hasNextPage(ListUsageLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUsageLimitsResponse> nextPage(ListUsageLimitsResponse previousPage) {
            if (previousPage == null) {
                return ListUsageLimitsPublisher.this.client.listUsageLimits(ListUsageLimitsPublisher.this.firstRequest);
            }
            return ListUsageLimitsPublisher.this.client.listUsageLimits((ListUsageLimitsRequest)((Object)ListUsageLimitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

