/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesRequest extends RedshiftDataRequest implements
        ToCopyableBuilder<ListTablesRequest.Builder, ListTablesRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ListTablesRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(ListTablesRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(ListTablesRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(ListTablesRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> CONNECTED_DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectedDatabase").getter(getter(ListTablesRequest::connectedDatabase))
            .setter(setter(Builder::connectedDatabase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDatabase").build()).build();

    private static final SdkField<String> SCHEMA_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaPattern").getter(getter(ListTablesRequest::schemaPattern)).setter(setter(Builder::schemaPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaPattern").build()).build();

    private static final SdkField<String> TABLE_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TablePattern").getter(getter(ListTablesRequest::tablePattern)).setter(setter(Builder::tablePattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePattern").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTablesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTablesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkgroupName").getter(getter(ListTablesRequest::workgroupName)).setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SECRET_ARN_FIELD, DB_USER_FIELD, DATABASE_FIELD, CONNECTED_DATABASE_FIELD, SCHEMA_PATTERN_FIELD, TABLE_PATTERN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, WORKGROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final String secretArn;

    private final String dbUser;

    private final String database;

    private final String connectedDatabase;

    private final String schemaPattern;

    private final String tablePattern;

    private final String nextToken;

    private final Integer maxResults;

    private final String workgroupName;

    private ListTablesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.secretArn = builder.secretArn;
        this.dbUser = builder.dbUser;
        this.database = builder.database;
        this.connectedDatabase = builder.connectedDatabase;
        this.schemaPattern = builder.schemaPattern;
        this.tablePattern = builder.tablePattern;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either
     * Secrets Manager or temporary credentials.
     * </p>
     * 
     * @return The cluster identifier. This parameter is required when connecting to a cluster and authenticating using
     *         either Secrets Manager or temporary credentials.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating
     * using Secrets Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. This parameter is required when
     *         authenticating using Secrets Manager.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The database user name. This parameter is required when connecting to a cluster as a database user and
     * authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. This parameter is required when connecting to a cluster as a database user and
     *         authenticating using temporary credentials.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified,
     * this is also the database to connect to with your authentication credentials.
     * </p>
     * 
     * @return The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not
     *         specified, this is also the database to connect to with your authentication credentials.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * A database name. The connected database is specified when you connect with your authentication credentials.
     * </p>
     * 
     * @return A database name. The connected database is specified when you connect with your authentication
     *         credentials.
     */
    public final String connectedDatabase() {
        return connectedDatabase;
    }

    /**
     * <p>
     * A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more
     * characters and "_" means match any one character. Only schema name entries matching the search pattern are
     * returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code>
     * are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables
     * are returned.
     * </p>
     * 
     * @return A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0
     *         or more characters and "_" means match any one character. Only schema name entries matching the search
     *         pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match
     *         <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or
     *         <code>TablePattern</code> are specified, then all tables are returned.
     */
    public final String schemaPattern() {
        return schemaPattern;
    }

    /**
     * <p>
     * A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more
     * characters and "_" means match any one character. Only table name entries matching the search pattern are
     * returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are
     * returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are
     * returned.
     * </p>
     * 
     * @return A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or
     *         more characters and "_" means match any one character. Only table name entries matching the search
     *         pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match
     *         <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or
     *         <code>TablePattern</code> are specified, then all tables are returned.
     */
    public final String tablePattern() {
        return tablePattern;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of tables to return in the response. If more tables exist than fit in one response, then
     * <code>NextToken</code> is returned to page through the results.
     * </p>
     * 
     * @return The maximum number of tables to return in the response. If more tables exist than fit in one response,
     *         then <code>NextToken</code> is returned to page through the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when connecting to a
     * serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     * </p>
     * 
     * @return The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when connecting
     *         to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(schemaPattern());
        hashCode = 31 * hashCode + Objects.hashCode(tablePattern());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(database(), other.database())
                && Objects.equals(connectedDatabase(), other.connectedDatabase())
                && Objects.equals(schemaPattern(), other.schemaPattern()) && Objects.equals(tablePattern(), other.tablePattern())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTablesRequest").add("ClusterIdentifier", clusterIdentifier()).add("SecretArn", secretArn())
                .add("DbUser", dbUser()).add("Database", database()).add("ConnectedDatabase", connectedDatabase())
                .add("SchemaPattern", schemaPattern()).add("TablePattern", tablePattern()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "ConnectedDatabase":
            return Optional.ofNullable(clazz.cast(connectedDatabase()));
        case "SchemaPattern":
            return Optional.ofNullable(clazz.cast(schemaPattern()));
        case "TablePattern":
            return Optional.ofNullable(clazz.cast(tablePattern()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "WorkgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("ConnectedDatabase", CONNECTED_DATABASE_FIELD);
        map.put("SchemaPattern", SCHEMA_PATTERN_FIELD);
        map.put("TablePattern", TABLE_PATTERN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("WorkgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTablesRequest, T> g) {
        return obj -> g.apply((ListTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesRequest> {
        /**
         * <p>
         * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using
         * either Secrets Manager or temporary credentials.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier. This parameter is required when connecting to a cluster and authenticating
         *        using either Secrets Manager or temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. This parameter is required when
         * authenticating using Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The name or ARN of the secret that enables access to the database. This parameter is required when
         *        authenticating using Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The database user name. This parameter is required when connecting to a cluster as a database user and
         * authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. This parameter is required when connecting to a cluster as a database user and
         *        authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not
         * specified, this is also the database to connect to with your authentication credentials.
         * </p>
         * 
         * @param database
         *        The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not
         *        specified, this is also the database to connect to with your authentication credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * A database name. The connected database is specified when you connect with your authentication credentials.
         * </p>
         * 
         * @param connectedDatabase
         *        A database name. The connected database is specified when you connect with your authentication
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDatabase(String connectedDatabase);

        /**
         * <p>
         * A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or
         * more characters and "_" means match any one character. Only schema name entries matching the search pattern
         * are returned. If <code>SchemaPattern</code> is not specified, then all tables that match
         * <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code>
         * are specified, then all tables are returned.
         * </p>
         * 
         * @param schemaPattern
         *        A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of
         *        0 or more characters and "_" means match any one character. Only schema name entries matching the
         *        search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that
         *        match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or
         *        <code>TablePattern</code> are specified, then all tables are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaPattern(String schemaPattern);

        /**
         * <p>
         * A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more
         * characters and "_" means match any one character. Only table name entries matching the search pattern are
         * returned. If <code>TablePattern</code> is not specified, then all tables that match
         * <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code>
         * are specified, then all tables are returned.
         * </p>
         * 
         * @param tablePattern
         *        A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0
         *        or more characters and "_" means match any one character. Only table name entries matching the search
         *        pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match
         *        <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or
         *        <code>TablePattern</code> are specified, then all tables are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePattern(String tablePattern);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of tables to return in the response. If more tables exist than fit in one response, then
         * <code>NextToken</code> is returned to page through the results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of tables to return in the response. If more tables exist than fit in one response,
         *        then <code>NextToken</code> is returned to page through the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when connecting to a
         * serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
         * </p>
         * 
         * @param workgroupName
         *        The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when
         *        connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftDataRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String secretArn;

        private String dbUser;

        private String database;

        private String connectedDatabase;

        private String schemaPattern;

        private String tablePattern;

        private String nextToken;

        private Integer maxResults;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            secretArn(model.secretArn);
            dbUser(model.dbUser);
            database(model.database);
            connectedDatabase(model.connectedDatabase);
            schemaPattern(model.schemaPattern);
            tablePattern(model.tablePattern);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            workgroupName(model.workgroupName);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getConnectedDatabase() {
            return connectedDatabase;
        }

        public final void setConnectedDatabase(String connectedDatabase) {
            this.connectedDatabase = connectedDatabase;
        }

        @Override
        public final Builder connectedDatabase(String connectedDatabase) {
            this.connectedDatabase = connectedDatabase;
            return this;
        }

        public final String getSchemaPattern() {
            return schemaPattern;
        }

        public final void setSchemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
        }

        @Override
        public final Builder schemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
            return this;
        }

        public final String getTablePattern() {
            return tablePattern;
        }

        public final void setTablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
        }

        @Override
        public final Builder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
